% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_contour_overlay_tSNE}
\alias{plot_contour_overlay_tSNE}
\title{Plot Gene Expression on tSNE}
\usage{
plot_contour_overlay_tSNE(environment, genes, perplexity = 30,
  max_iter = 10000, width = 10, height = 10)
}
\arguments{
\item{environment}{\code{environment} object}

\item{genes}{selected genes to visualize}

\item{perplexity}{tSNE perplexity parameter}

\item{max_iter}{tSNE max_iter parameter}

\item{width}{pdf file canvas width}

\item{height}{pdf file canvas height}
}
\description{
Visualize normalized expression of selected genes on tSNE plot with color-code and contour annotation.
}
\examples{
\donttest{
LCMV1 <- setup_LCMV_example()
LCMV1 <- get.variable.genes(LCMV1, min.mean = 0.1, min.frac.cells = 0,
min.dispersion.scaled = 0.1)
LCMV1 <- PCA(LCMV1)
LCMV1 <- cluster.analysis(LCMV1)
plot_contour_overlay_tSNE(LCMV1,genes = c('Cd4','Cd8a'))
}
}
