% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitMediation.R
\name{fitMediation}
\alias{fitMediation}
\alias{print.fitMediation}
\alias{summary.covFitMediation}
\alias{summary.regFitMediation}
\title{(Robustly) fit a mediation model}
\usage{
fitMediation(x, y, m, covariates = NULL, data, method = c("covariance",
  "regression"), robust = TRUE, control, ...)
}
\arguments{
\item{x}{either a numeric vector containing the independent variable, or
(if \code{data} is supplied) a character string, an integer or a logical
vector specifying the corresponding column of \code{data}.}

\item{y}{either a numeric vector containing the dependent variable, or
(if \code{data} is supplied) a character string, an integer or a logical
vector specifying the corresponding column of \code{data}.}

\item{m}{either a numeric vector containing the proposed mediator variable,
or (if \code{data} is supplied) a character string, an integer or a logical
vector specifying the corresponding column of \code{data}.}

\item{covariates}{optional; either a numeric vector or data frame
containing additional covariates to be used as control variables, or (if
\code{data} is supplied) a character, integer or logical vector specifying
the corresponding column of \code{data}.}

\item{data}{an optional \code{data.frame}.}

\item{method}{a character string specifying the method of
estimation.  Possible values are \code{"covariance"} (the default) to
estimate the effects via the covariance matrix, or \code{"regression"}
to estimate the effects via regressions.  Note that the effects are
always estimated via regressions if control variables are specified via
\code{covariates}.}

\item{robust}{a logical indicating whether to robustly estimate the effects
(defaults to \code{TRUE}).  This is currently ignored if \code{method} is
\code{"regression"}.}

\item{control}{if \code{robust} is \code{TRUE} and \code{method} is
\code{"covariance"}, a list of tuning parameters for \code{\link{covHuber}}
as generated by \code{\link{covControl}}.}

\item{\dots}{additional arguments can be used to specify tuning parameters
directly instead of via \code{control}.}
}
\value{
An object inheriting from class \code{"fitMediation"} (class
\code{"regFitMediation"} if \code{method} is \code{"regression"} or
\code{"covFitMediation"} if \code{method} is \code{"covariance"}) with
the following components:
\item{a}{numeric; the point estimate of the effect of the independent
variable on the proposed mediator variable.}
\item{b}{numeric; the point estimate of the direct effect of the
proposed mediator variable on the dependent variable.}
\item{c}{numeric; the point estimate of the direct effect of the
independent variable on the dependent variable.}
\item{cPrime}{numeric; the point estimate of the total effect of the
independent variable on the dependent variable.}
\item{robust}{a logical indicating whether the effects were estimated
robustly.}
\item{fitMX}{an object of class \code{"\link[stats]{lm}"} containing the
estimation results from the regression of the proposed mediator variable
on the independent variable (only \code{"regFitMediation"}).}
\item{fitYMX}{an object of class \code{"\link[stats]{lm}"} containing the
estimation results from the regression of the dependent variable on the
proposed mediator and independent variables (only \code{"regFitMediation"}).}
\item{fitYX}{an object of class \code{"\link[stats]{lm}"} containing the
estimation results from the regression of the dependent variable on the
independent variable (only \code{"regFitMediation"}).}
\item{cov}{an object of class \code{"\link{covHuber}"} or
\code{"\link{covML}"} containing the covariance matrix estimates (only
\code{"covFitMediation"}).}
\item{data}{a data frame containing the independent, dependent and
proposed mediator variables.}
}
\description{
(Robustly) estimate the effects in a mediation model.
}
\details{
If \code{method} is \code{"covariance"} and \code{robust} is \code{TRUE}
(the default), the effects are estimated based on a Huber M-estimator of
location and scatter.

A much more robust method based on robust regression will be available
soon.  Currently, least squares regression is always performed if
\code{method} is \code{"regression"}.
}
\examples{
# control parameters
n <- 250             # number of observations
a <- b <- c <- 0.2   # true effects
t <- 2               # number of observations to contaminate

# draw clean observations
set.seed(20160911)
x <- rnorm(n)
m <- a * x + rnorm(n)
y <- b * m + c * x + rnorm(n)

# contaminate the first t observations
m[1:t] <- m[1:t] - 6
y[1:t] <- y[1:t] + 6

# fit mediation model
fitMediation(x, y, m)

}
\author{
Andreas Alfons
}
\references{
Zu, J. and Yuan, K.-H. (2010) Local influence and robust procedures for
mediation analysis. \emph{Multivariate Behavioral Research}, \bold{45}(1),
1--44.
}
\seealso{
\code{\link{testMediation}}

\code{\link{covHuber}}, \code{\link{covML}}, \code{\link[stats]{lm}}
}
\keyword{multivariate}

