% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rSDev.test.R
\name{rSDev.test}
\alias{rSDev.test}
\title{Relative simplicial deviance tests}
\usage{
rSDev.test(x, R = 999, method = "multinom")
}
\arguments{
\item{x}{matrix, data.frame or table}

\item{R}{an integer specifying the number of replicates used in the Monte Carlo test.}

\item{method}{either \dQuote{rmultinom} (default) or \dQuote{permutation}.}
}
\value{
A list with class  \dQuote{htest} containing the following components:
\itemize{
  \item{statistic}{the value of the relative simplicial deviance (test statistic).}
  \item{method}{a character string indicating what type of rSDev.test was performed.}
  \item{p.value}{the p-value for the test.}
}
}
\description{
Monte Carlo based contingency table tests considering the compositional approach to contingency tables.
}
\details{
Method \dQuote{rmultinom} generate multinomially distributed samples  
from the independent probability table, which is estimated from \code{x} using geometric mean marginals. 
The relative simplicial deviance of the original data are then compared to the generated ones.

Method \dQuote{permutation} permutes the entries of \code{x} and compares the relative simplicial deviance estimated from
the original data to the ones of the permuted data (the independence table is unchanged and originates on \code{x}). 

Method \dQuote{rmultinom} should be preferred, while method \dQuote{permutation} can be used for comparisons.
}
\examples{
data(precipitation)
rSDev.test(precipitation)
}
\references{
Juan Jose Egozcuea, Vera Pawlowsky-Glahn, Matthias Templ, Karel Hron (2015)
Independence in Contingency Tables Using Simplicial Geometry. 
\emph{Communications in Statistics - Theory and Methods}, Vol. 44 (18), 3978--3996.
DOI:10.1080/03610926.2013.824980
}
\seealso{
\code{\link{rSDev}}
}
\author{
Matthias Templ, Karel Hron
}
\keyword{htest}
