% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fData.R
\name{sub-.fData}
\alias{sub-.fData}
\alias{[.fData}
\title{Operator \code{sub-.fData} to subset \code{fData} obejcts}
\usage{
\method{[}{fData}(fD, i, j, as_fData = TRUE)
}
\arguments{
\item{fD}{the univariate functional dataset in form of \code{fData} object.}

\item{i}{a valid expression to subset rows ( observations ) of the univariate
functional dataset}

\item{j}{a valid expression to subset columns ( measurements over the grid )
of the univariate functional dataset.}

\item{as_fData}{logical flag to specify whether the output should be returned
as an \code{fData} object containing the required subset or as a matrix of
values, default is \code{TRUE}.}
}
\value{
The method returns either an \code{fData} object ( if \code{as_fData
= TRUE } ) or a \code{matrix} ( if \code{as_fData = FALSE } ) containing the
required subset ( both in terms  of observations and measurement points ) of
the univariate functional dataset.
}
\description{
This method provides an easy and natural way to subset a functional dataset
stored in a \code{fData} object, without having to deal with the inner
representation of \code{fData} class.
}
\examples{

N = 20
P = 1e2

# One dimensional grid
grid = seq( 0, 1, length.out = P )

# Generating an exponential covariance function (see related help for more
# information )
C = exp_cov_function( grid, alpha = 0.3, beta = 0.4 )

# Generating a synthetic dataset with a gaussian distribution and
# required mean and covariance function:
fD = fData( grid,
            generate_gauss_fdata( N,
                                  centerline = sin( 2 * pi * grid ),
                                  Cov = C ) )

dev.new()
par( mfrow = c( 2, 2 ) )

# Original data
plot( fD )

# Subsetting observations
plot( fD[ c(1,2,3), , as_fData = TRUE ] )

# Subsetting measurements
plot( fD[ , 1 : 30 ] )

# Subsetting both observations and measurements
plot( fD[ 1 : 10, 50 : P ] )

# Subsetting both observations and measurements but returning a matrix
fD[ 1 : 10, 50 : P, as_fData = FALSE ]

}
\seealso{
\code{\link{fData}}
}
