% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlation.R
\name{area_under_curve}
\alias{area_under_curve}
\title{Area under curve of elements of univariate functional data}
\usage{
area_under_curve(fData)
}
\arguments{
\item{fData}{the functional dataset containing elements whose areas under the
curve have to be computed, in form of \code{fData} object.}
}
\value{
The function returns a numeric vector containing the values of areas
under the curve for all the elements of the functional dataset \code{fData}.
}
\description{
This method computes the (signed) area under the curve of elements of a
univariate functional dataset, namely, their integral.
}
\examples{

P = 1e3
grid = seq( 0, 1, length.out = P )

fD = fData( grid,
            matrix( c( sin( 2 * pi * grid ),
                       cos( 2 * pi * grid ),
                       4 * grid * ( 1 - grid ) ),
                    nrow = 3, ncol = P, byrow = TRUE ) )
plot( fD )

area_under_curve( fD )

}
\seealso{
\code{\link{area_ordered}}, \code{\link{fData}}
}

