% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_data.R
\name{ne_find_vector_data}
\alias{ne_find_vector_data}
\title{Return a dataframe of available vector layers on Natural Earth}
\usage{
ne_find_vector_data(
  scale = 110,
  category = c("cultural", "physical"),
  getmeta = FALSE
)
}
\arguments{
\item{scale}{scale of map to return, one of \code{110}, \code{50}, \code{10}
or \code{'small'}, \code{'medium'}, \code{'large'}}

\item{category}{one of natural earth categories : 'cultural', 'physical'}

\item{getmeta}{whether to get url of the metadata for each layer}
}
\value{
dataframe with two variables: layer and metadata
}
\description{
Checks the Natural Earth Github repository for current vector layers and
provides the file name required in the type argument of ne_download.
}
\examples{
\dontrun{
ne_find_vector_data(scale = 10, category = "physical")
}
}
