% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmw_partial_dependencies.R
\name{rmw_partial_dependencies}
\alias{rmw_partial_dependencies}
\title{Function to calculate partial dependencies after training with 
\strong{rmweather}.}
\usage{
rmw_partial_dependencies(model, df, variable, n_cores = NA, verbose = FALSE)
}
\arguments{
\item{model}{A ranger model object from \code{\link{rmw_train_model}}.}

\item{df}{Input data frame after preparation with 
\code{\link{rmw_prepare_data}}.}

\item{variable}{Vector of variables to calculate partial dependencies for.}

\item{n_cores}{Number of CPU cores to use for the model calculation. Default
is system's total minus one.}

\item{verbose}{Should the function give messages?}
}
\value{
Tibble.
}
\description{
\code{rmw_plot_partial_dependencies} is rather slow.
}
\examples{

\donttest{

# Ranger package needs to be loaded
library(ranger)

# Calculate partial dependencies for wind speed
data_partial <- rmw_partial_dependencies(
  model = model_london, 
  df = rmw_prepare_data(data_london, value = "no2"), 
  variable = "ws", 
  verbose = TRUE
)

# Calculate partial dependencies for all independent variables used in model
data_partial <- rmw_partial_dependencies(
  model = model_london, 
  df = rmw_prepare_data(data_london, value = "no2"), 
  variable = NA, 
  verbose = TRUE
)

}

}
\author{
Stuart K. Grange
}
