/* Copyright 2014 IPB, Universite de Bordeaux, INRIA & CNRS
**
** This file is part of the Scotch software package for static mapping,
** graph partitioning and sparse matrix ordering.
**
** This software is governed by the CeCILL-C license under French law
** and abiding by the rules of distribution of free software. You can
** use, modify and/or redistribute the software under the terms of the
** CeCILL-C license as circulated by CEA, CNRS and INRIA at the following
** URL: "http://www.cecill.info".
** 
** As a counterpart to the access to the source code and rights to copy,
** modify and redistribute granted by the license, users are provided
** only with a limited warranty and the software's author, the holder of
** the economic rights, and the successive licensors have only limited
** liability.
** 
** In this respect, the user's attention is drawn to the risks associated
** with loading, using, modifying and/or developing or reproducing the
** software by the user in light of its specific status of free software,
** that may mean that it is complicated to manipulate, and that also
** therefore means that it is reserved for developers and experienced
** professionals having in-depth computer knowledge. Users are therefore
** encouraged to load and test the software's suitability as regards
** their requirements in conditions enabling the security of their
** systems and/or data to be ensured and, more generally, to use and
** operate it in the same conditions as regards security.
** 
** The fact that you are presently reading this means that you have had
** knowledge of the CeCILL-C license and that you accept its terms.
*/
/************************************************************/
/**                                                        **/
/**   NAME       : library_memory.c                        **/
/**                                                        **/
/**   AUTHOR     : Francois PELLEGRINI                     **/
/**                                                        **/
/**   FUNCTION   : This module is the API for the memory   **/
/**                handling routines.                      **/
/**                                                        **/
/**   DATES      : # Version 6.0  : from : 21 sep 2014     **/
/**                                 to     23 sep 2014     **/
/**                                                        **/
/************************************************************/

/*
**  The defines and includes.
*/

#define LIBRARY

#include "module.h"
#include "common.h"
#include "scotch.h"

/************************************/
/*                                  */
/* These routines are the C API for */
/* the memory management routines.  */
/*                                  */
/************************************/

/*+ This routine frees a structure allocated
*** by a SCOTCH_*Alloc () routine.
*** It returns:
*** - void  : in all cases.
+*/

void
SCOTCH_memFree (
void * const                dataptr)
{
  memFree (dataptr);
}

/*+ This routine returns the size, in bytes,
*** of a SCOTCH_Num.
*** It returns:
*** - void  : in all cases.
+*/

int
SCOTCH_numSizeof ()
{
  return (sizeof (SCOTCH_Num));
}
