% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/side_monad-to-x.R
\name{esc}
\alias{esc}
\title{Returns the value of a monad holds}
\usage{
esc(m, quiet = FALSE)
}
\arguments{
\item{m}{An Rmonad}

\item{quiet}{If TRUE, print the exact messages that are raised, without
extra context.}
}
\description{
If the monad is in the passing state, return the wrapped value. Otherwise,
raise an appropriate error.
}
\details{
Regardless of pass/fail status, \code{esc} raises all collected warnings and
prints all messages. Terminating a monadic sequence with \code{esc} should
obtain a result very close to running the same code outside the monad. The
main difference is that Rmonad appends the toplevel code that generated the
error.
}
\seealso{
Other from_Rmonad: \code{\link{as_dgr_graph}},
  \code{\link{missues}}, \code{\link{mreport}},
  \code{\link{mtabulate}}
}
