% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PrepareSimulationData.R
\name{PrepareSimulationData}
\alias{PrepareSimulationData}
\title{PrepareSimulationData}
\usage{
PrepareSimulationData(object, policies, nsims = 30, class = "class1")
}
\arguments{
\item{object}{an object of class `mdcev`}

\item{policies}{list containing
price_p with additive price increases, and
dat_psi_p with new psi data}

\item{nsims}{Number of simulation draws to use for parameter uncertainty}

\item{class}{The class number for Latent Class models.}
}
\value{
A list with individual-specific data (df_indiv) and common data (df_common)
and n_classes for number of classes and model_num for model type
}
\description{
Prepare Data for WTP simulation
}
\examples{
\donttest{
data(data_rec, package = "rmdcev")

data_rec <- mdcev.data(data_rec, subset = id <= 500, id.var = "id",
                alt.var = "alt", choice = "quant")

mdcev_est <- mdcev( ~ 0, data = data_rec,
               model = "hybrid0", algorithm = "MLE",
               std_errors = "mvn")

policies <- CreateBlankPolicies(npols = 2, mdcev_est,
             price_change_only = TRUE)

df_sim <- PrepareSimulationData(mdcev_est, policies)

}
}
