/*
 * Decompiled with CFR 0.152.
 */
package weka.core.matrix;

import java.lang.reflect.Method;
import java.util.Arrays;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.matrix.FlexibleDecimalFormat;
import weka.core.matrix.IntVector;

public class DoubleVector
implements Cloneable,
RevisionHandler {
    double[] V;
    private int sizeOfVector;

    public DoubleVector() {
        this(0);
    }

    public DoubleVector(int n) {
        this.V = new double[n];
        this.setSize(n);
    }

    public DoubleVector(int n, double s) {
        this(n);
        this.set(s);
    }

    public DoubleVector(double[] v) {
        if (v == null) {
            this.V = new double[0];
            this.setSize(0);
        } else {
            this.V = v;
            this.setSize(v.length);
        }
    }

    public void set(int i, double s) {
        this.V[i] = s;
    }

    public void set(double s) {
        this.set(0, this.size() - 1, s);
    }

    public void set(int i0, int i1, double s) {
        int i = i0;
        while (i <= i1) {
            this.V[i] = s;
            ++i;
        }
    }

    public void set(int i0, int i1, double[] v, int j0) {
        int i = i0;
        while (i <= i1) {
            this.V[i] = v[j0 + i - i0];
            ++i;
        }
    }

    public void set(DoubleVector v) {
        this.set(0, v.size() - 1, v, 0);
    }

    public void set(int i0, int i1, DoubleVector v, int j0) {
        int i = i0;
        while (i <= i1) {
            this.V[i] = v.V[j0 + i - i0];
            ++i;
        }
    }

    public double[] getArray() {
        return this.V;
    }

    void setArray(double[] a) {
        this.V = a;
    }

    public double[] getArrayCopy() {
        double[] v = new double[this.size()];
        int i = 0;
        while (i < this.size()) {
            v[i] = this.V[i];
            ++i;
        }
        return v;
    }

    public void sort() {
        Arrays.sort(this.V, 0, this.size());
    }

    public IntVector sortWithIndex() {
        IntVector index = IntVector.seq(0, this.size() - 1);
        this.sortWithIndex(0, this.size() - 1, index);
        return index;
    }

    /*
     * Unable to fully structure code
     */
    public void sortWithIndex(int xi, int xj, IntVector index) {
        block3: {
            if (xi >= xj) break block3;
            xm = (xi + xj) / 2;
            x = Math.min(this.V[xi], Math.max(this.V[xm], this.V[xj]));
            i = xi;
            j = xj;
            ** GOTO lbl18
            {
                ++i;
                do {
                    if (this.V[i] < x && i < xj) continue block0;
                    while (this.V[j] > x && j > xi) {
                        --j;
                    }
                    if (i > j) continue;
                    this.swap(i, j);
                    index.swap(i, j);
                    ++i;
                    --j;
lbl18:
                    // 3 sources

                } while (i < j);
            }
            this.sortWithIndex(xi, j, index);
            this.sortWithIndex(i, xj, index);
        }
    }

    public int size() {
        return this.sizeOfVector;
    }

    public void setSize(int m) {
        if (m > this.capacity()) {
            throw new IllegalArgumentException("insufficient capacity");
        }
        this.sizeOfVector = m;
    }

    public int capacity() {
        if (this.V == null) {
            return 0;
        }
        return this.V.length;
    }

    public void setCapacity(int n) {
        if (n == this.capacity()) {
            return;
        }
        double[] oldV = this.V;
        int m = Math.min(n, this.size());
        this.V = new double[n];
        this.setSize(m);
        this.set(0, m - 1, oldV, 0);
    }

    public double get(int i) {
        return this.V[i];
    }

    public void setPlus(int i, double s) {
        int n = i;
        this.V[n] = this.V[n] + s;
    }

    public void setTimes(int i, double s) {
        int n = i;
        this.V[n] = this.V[n] * s;
    }

    public void addElement(double x) {
        if (this.capacity() == 0) {
            this.setCapacity(10);
        }
        if (this.size() == this.capacity()) {
            this.setCapacity(2 * this.capacity());
        }
        this.V[this.size()] = x;
        this.setSize(this.size() + 1);
    }

    public DoubleVector square() {
        DoubleVector v = new DoubleVector(this.size());
        int i = 0;
        while (i < this.size()) {
            v.V[i] = this.V[i] * this.V[i];
            ++i;
        }
        return v;
    }

    public DoubleVector sqrt() {
        DoubleVector v = new DoubleVector(this.size());
        int i = 0;
        while (i < this.size()) {
            v.V[i] = Math.sqrt(this.V[i]);
            ++i;
        }
        return v;
    }

    public DoubleVector copy() {
        return (DoubleVector)this.clone();
    }

    public Object clone() {
        int n = this.size();
        DoubleVector u = new DoubleVector(n);
        int i = 0;
        while (i < n) {
            u.V[i] = this.V[i];
            ++i;
        }
        return u;
    }

    public double innerProduct(DoubleVector v) {
        if (this.size() != v.size()) {
            throw new IllegalArgumentException("sizes unmatch");
        }
        double p = 0.0;
        int i = 0;
        while (i < this.size()) {
            p += this.V[i] * v.V[i];
            ++i;
        }
        return p;
    }

    public DoubleVector sign() {
        DoubleVector s = new DoubleVector(this.size());
        int i = 0;
        while (i < this.size()) {
            s.V[i] = this.V[i] > 0.0 ? 1.0 : (this.V[i] < 0.0 ? -1.0 : 0.0);
            ++i;
        }
        return s;
    }

    public double sum() {
        double s = 0.0;
        int i = 0;
        while (i < this.size()) {
            s += this.V[i];
            ++i;
        }
        return s;
    }

    public double sum2() {
        double s2 = 0.0;
        int i = 0;
        while (i < this.size()) {
            s2 += this.V[i] * this.V[i];
            ++i;
        }
        return s2;
    }

    public double norm1() {
        double s = 0.0;
        int i = 0;
        while (i < this.size()) {
            s += Math.abs(this.V[i]);
            ++i;
        }
        return s;
    }

    public double norm2() {
        return Math.sqrt(this.sum2());
    }

    public double sum2(DoubleVector v) {
        return this.minus(v).sum2();
    }

    public DoubleVector subvector(int i0, int i1) {
        DoubleVector v = new DoubleVector(i1 - i0 + 1);
        v.set(0, i1 - i0, this, i0);
        return v;
    }

    public DoubleVector subvector(IntVector index) {
        DoubleVector v = new DoubleVector(index.size());
        int i = 0;
        while (i < index.size()) {
            v.V[i] = this.V[index.V[i]];
            ++i;
        }
        return v;
    }

    public DoubleVector unpivoting(IntVector index, int length) {
        if (index.size() > length) {
            throw new IllegalArgumentException("index.size() > length ");
        }
        DoubleVector u = new DoubleVector(length);
        int i = 0;
        while (i < index.size()) {
            u.V[index.V[i]] = this.V[i];
            ++i;
        }
        return u;
    }

    public DoubleVector plus(double x) {
        return this.copy().plusEquals(x);
    }

    public DoubleVector plusEquals(double x) {
        int i = 0;
        while (i < this.size()) {
            int n = i++;
            this.V[n] = this.V[n] + x;
        }
        return this;
    }

    public DoubleVector plus(DoubleVector v) {
        return this.copy().plusEquals(v);
    }

    public DoubleVector plusEquals(DoubleVector v) {
        int i = 0;
        while (i < this.size()) {
            int n = i;
            this.V[n] = this.V[n] + v.V[i];
            ++i;
        }
        return this;
    }

    public DoubleVector minus(double x) {
        return this.plus(-x);
    }

    public DoubleVector minusEquals(double x) {
        this.plusEquals(-x);
        return this;
    }

    public DoubleVector minus(DoubleVector v) {
        return this.copy().minusEquals(v);
    }

    public DoubleVector minusEquals(DoubleVector v) {
        int i = 0;
        while (i < this.size()) {
            int n = i;
            this.V[n] = this.V[n] - v.V[i];
            ++i;
        }
        return this;
    }

    public DoubleVector times(double s) {
        return this.copy().timesEquals(s);
    }

    public DoubleVector timesEquals(double s) {
        int i = 0;
        while (i < this.size()) {
            int n = i++;
            this.V[n] = this.V[n] * s;
        }
        return this;
    }

    public DoubleVector times(DoubleVector v) {
        return this.copy().timesEquals(v);
    }

    public DoubleVector timesEquals(DoubleVector v) {
        int i = 0;
        while (i < this.size()) {
            int n = i;
            this.V[n] = this.V[n] * v.V[i];
            ++i;
        }
        return this;
    }

    public DoubleVector dividedBy(DoubleVector v) {
        return this.copy().dividedByEquals(v);
    }

    public DoubleVector dividedByEquals(DoubleVector v) {
        int i = 0;
        while (i < this.size()) {
            int n = i;
            this.V[n] = this.V[n] / v.V[i];
            ++i;
        }
        return this;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public DoubleVector cumulate() {
        return this.copy().cumulateInPlace();
    }

    public DoubleVector cumulateInPlace() {
        int i = 1;
        while (i < this.size()) {
            int n = i;
            this.V[n] = this.V[n] + this.V[i - 1];
            ++i;
        }
        return this;
    }

    public int indexOfMax() {
        int index = 0;
        double ma = this.V[0];
        int i = 1;
        while (i < this.size()) {
            if (ma < this.V[i]) {
                ma = this.V[i];
                index = i;
            }
            ++i;
        }
        return index;
    }

    public boolean unsorted() {
        if (this.size() < 2) {
            return false;
        }
        int i = 1;
        while (i < this.size()) {
            if (this.V[i - 1] > this.V[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public DoubleVector cat(DoubleVector v) {
        DoubleVector w = new DoubleVector(this.size() + v.size());
        w.set(0, this.size() - 1, this, 0);
        w.set(this.size(), this.size() + v.size() - 1, v, 0);
        return w;
    }

    public void swap(int i, int j) {
        if (i == j) {
            return;
        }
        double t = this.V[i];
        this.V[i] = this.V[j];
        this.V[j] = t;
    }

    public double max() {
        if (this.size() < 1) {
            throw new IllegalArgumentException("zero size");
        }
        double ma = this.V[0];
        if (this.size() < 2) {
            return ma;
        }
        int i = 1;
        while (i < this.size()) {
            if (this.V[i] > ma) {
                ma = this.V[i];
            }
            ++i;
        }
        return ma;
    }

    public DoubleVector map(String className, String method) {
        try {
            Class<?> c = Class.forName(className);
            Class[] cs = new Class[]{Double.TYPE};
            Method m = c.getMethod(method, cs);
            DoubleVector w = new DoubleVector(this.size());
            Object[] obj = new Object[1];
            int i = 0;
            while (i < this.size()) {
                obj[0] = new Double(this.V[i]);
                w.set(i, Double.parseDouble(m.invoke(null, obj).toString()));
                ++i;
            }
            return w;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
            return null;
        }
    }

    public DoubleVector rev() {
        int n = this.size();
        DoubleVector w = new DoubleVector(n);
        int i = 0;
        while (i < n) {
            w.V[i] = this.V[n - i - 1];
            ++i;
        }
        return w;
    }

    public static DoubleVector random(int n) {
        DoubleVector v = new DoubleVector(n);
        int i = 0;
        while (i < n) {
            v.V[i] = Math.random();
            ++i;
        }
        return v;
    }

    public String toString() {
        return this.toString(5, false);
    }

    public String toString(int digits, boolean trailing) {
        if (this.isEmpty()) {
            return "null vector";
        }
        StringBuffer text = new StringBuffer();
        FlexibleDecimalFormat nf = new FlexibleDecimalFormat(digits, trailing);
        nf.grouping(true);
        int i = 0;
        while (i < this.size()) {
            nf.update(this.V[i]);
            ++i;
        }
        int count = 0;
        int width = 80;
        int i2 = 0;
        while (i2 < this.size()) {
            String number = nf.format(this.V[i2]);
            if ((count += 1 + number.length()) > width - 1) {
                text.append('\n');
                count = 1 + number.length();
            }
            text.append(" " + number);
            ++i2;
        }
        return text.toString();
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.4 $");
    }

    public static void main(String[] args) {
        DoubleVector a;
        DoubleVector u = DoubleVector.random(10);
        DoubleVector v = DoubleVector.random(10);
        DoubleVector w = a = DoubleVector.random(10);
        System.out.println(DoubleVector.random(10).plus(v).plus(w));
    }
}

