% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/def_econs.R
\name{def_econs}
\alias{def_econs}
\title{Define economic resources}
\usage{
def_econs(econ = NULL, econ_type = NULL, econ_class = NULL, econ_id = NULL)
}
\arguments{
\item{econ}{\code{character}. The name of the economic resource (e.g., "gas
reservoir") to return a definition for.}

\item{econ_type}{\code{character}. The type of economic resource (e.g.,
"hydrocarbon") to return a definition for.}

\item{econ_class}{\code{character}. The class of economic resource (e.g.,
"energy") to return a definition for.}

\item{econ_id}{\code{integer}. The unique identification number(s) of the
economic resource(s) to return a definition for.}
}
\value{
A \code{data.frame} containing the following columns:
\itemize{
\item \code{econ_id}: The unique identifier of the economic resource.
\item \code{name}: The name of the economic resource.
\item \code{type}: The type of economic resource.
\item \code{class}: The class of economic resource.
\item \code{color}: The recommended coloring for units based on the dominant
lithology.
\item \code{t_units}: The total number of Macrostrat units containing the
economic resource.
}
}
\description{
A function to retrieve the definitions for one or more
economic resources in the Macrostrat database. By default, all economic
definitions are returned.
}
\section{Developer(s)}{

Bethany Allen
}

\section{Reviewer(s)}{

William Gearty
}

\examples{
\donttest{
# Return all economic resource definitions
econ_inf <- def_econs()
# Return only definitions for hydrocarbon resources
econ_inf <- def_econs(econ_type = "hydrocarbon")
}
}
\seealso{
Geologic features and attributes:
\code{\link{def_environments}()},
\code{\link{def_grain_sizes}()},
\code{\link{def_lithologies}()},
\code{\link{def_lithology_att}()},
\code{\link{def_measurements}()},
\code{\link{def_minerals}()},
\code{\link{def_structures}()}
}
\concept{defs_feat}
