% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/varbeta.R
\name{varbeta}
\alias{varbeta}
\title{Recovering a Symmetric Matrix from Its Lower Triangular Matrix}
\usage{
varbeta(lower.tri.vector, diag = TRUE)
}
\arguments{
\item{lower.tri.vector}{a numerical vector containing the lower triangular
elements of the symmetric matrix.}

\item{diag}{a logical indicator, \code{TRUE} or \code{FALSE}, indicating if
\code{lower.tri.vector} contains diagonal elements of the symmetric matrix or not.}
}
\value{
The function \code{varbeta} returns the original symmetric matrix. We
  only use \code{diag = FALSE} to recover the correlation matrix, because
  diagonal elements of a correlation matrix are all 1, so there is no reason
  to store these diagonal elements in this case.
}
\description{
This function recovers a symmetric matrix from the vector consisting of its
lower triangular elements.
}
\details{
\code{diag = FALSE} is the case where a correlation matrix whose diagonal
elements are 1, therefore there is no need in storing the diagonal elements.
}
\examples{
\donttest{
set.seed(1)
lower.tri.vector <- runif(10)
varout <- rmRNAseq:::varbeta(lower.tri.vector, diag=TRUE)
varout
}
}
\references{
Yet Nguyen, Dan Nettleton, 2019. rmRNAseq: RNA-seq Analysis for Repeated-measures Data
}
\author{
Yet Nguyen \email{ynguyen@odu.edu}
}
