% Generated by roxygen2 (4.0.1): do not edit by hand
\name{list.map}
\alias{list.map}
\title{Map each member of a list by an expression.}
\usage{
list.map(x, expr, keep.names = TRUE, keep.null = FALSE)
}
\arguments{
\item{x}{The list to perform mapping}

\item{expr}{An expression that is evaluated for each item}

\item{keep.names}{Whether to keep the names of list x}

\item{keep.null}{Whether to keep \code{NULL} items in the result}
}
\description{
Map each member of a list by an expression.
}
\examples{
\dontrun{
x <- list(p1 = list(type="A",score=list(c1=10,c2=8)),
       p2 = list(type="B",score=list(c1=9,c2=9)),
       p3 = list(type="B",score=list(c1=9,c2=7)))
list.map(x,type)
list.map(x,min(score$c1,score$c2))
}
}

