% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{plotBarcodeRank}
\alias{plotBarcodeRank}
\title{Create barcode-rank plot for each dataset}
\usage{
plotBarcodeRank(object, ...)
}
\arguments{
\item{object}{A \linkS4class{liger} object.}

\item{...}{
  Arguments passed on to \code{\link[=.ggScatter]{.ggScatter}}, \code{\link[=.ggplotLigerTheme]{.ggplotLigerTheme}}
  \describe{
    \item{\code{dotSize,dotAlpha}}{Numeric, controls the size or transparency of all
dots. Default \code{getOption("ligerDotSize")} (1) and \code{0.9}.}
    \item{\code{raster}}{Logical, whether to rasterize the plot. Default \code{NULL}
automatically rasterize the plot when number of total dots to be plotted
exceeds 100,000.}
    \item{\code{title,subtitle,xlab,ylab}}{Main title, subtitle or X/Y axis title text.
By default, no main title or subtitle will be set, and X/Y axis title will be
the names of variables used for plotting. Use \code{NULL} to hide elements.
\code{TRUE} for \code{xlab} or \code{ylab} shows default values.}
    \item{\code{baseSize}}{One-parameter control of all text sizes. Individual text
element sizes can be controlled by other size arguments. "Title" sizes are
2 points larger than "text" sizes when being controlled by this.}
    \item{\code{panelBorder}}{Whether to show rectangle border of the panel instead of
using ggplot classic bottom and left axis lines. Default \code{FALSE}.}
    \item{\code{plotly}}{Whether to use plotly to enable web based interactive browsing
for the plot. Requires installation of package "plotly". Default
\code{FALSE}.}
  }}
}
\value{
A list object of ggplot for each dataset
}
\description{
This function ranks the total count of each cell within each dataset and make
line plot. This function is simply for examining the input raw count data
and does not infer any recommended cutoff for removing non-cell barcodes.
}
\examples{
plotBarcodeRank(pbmc)
}
