% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DEG_marker.R
\name{plotMarkerHeatmap}
\alias{plotMarkerHeatmap}
\title{Create heatmap for showing top marker expression in conditions}
\usage{
plotMarkerHeatmap(
  object,
  result,
  topN = 5,
  lfcThresh = 1,
  padjThresh = 0.05,
  pctInThresh = 50,
  pctOutThresh = 50,
  dedupBy = c("logFC", "padj"),
  groupBy = NULL,
  groupSize = 50,
  column_title = NULL,
  ...
)
}
\arguments{
\item{object}{A \linkS4class{liger} object, with normalized data and metadata
to annotate available.}

\item{result}{The data.frame returned by \code{\link{runMarkerDEG}}.}

\item{topN}{Number of top features to be plot for each group. Default
\code{5}.}

\item{lfcThresh}{Hard threshold on logFC value. Default \code{1}.}

\item{padjThresh}{Hard threshold on adjusted P-value. Default \code{0.05}.}

\item{pctInThresh, pctOutThresh}{Threshold on expression percentage. These
mean that a feature will only pass the filter if it is expressed in more than
\code{pctInThresh} percent of cells in the corresponding cluster. Similarly
for \code{pctOutThresh}. Only applied when these metrics are available.
Default \code{50} percent for both.}

\item{dedupBy}{When ranking by padj and logFC and a feature is ranked as top
for multiple clusters, assign this feature as the marker of a cluster when
it has the largest \code{"logFC"} in the cluster or has the lowest
\code{"padj"}. Default \code{"logFC"}.}

\item{groupBy}{Cell metadata variable names for cell grouping. Downsample
balancing will also be aware of this. Default \code{"dataset"} and the
default cluster.}

\item{groupSize}{Maximum number of cells in each group to be downsampled for
plotting. Default \code{50}.}

\item{column_title}{Title on the column. Default \code{NULL}.}

\item{...}{
  Arguments passed on to \code{\link[=plotGeneHeatmap]{plotGeneHeatmap}}, \code{\link[=.plotHeatmap]{.plotHeatmap}}
  \describe{
    \item{\code{cellAnnotation}}{data.frame object for using external annotation, with
each column a variable and each row is a cell. Row names of this data.frame
will be used for matching cells involved in heatmap. For cells not found in
this data.frame, \code{NA}s will be added with warning. Default \code{NULL}.}
    \item{\code{transpose}}{Logical, whether to "rotate" the heatmap by 90 degrees so
that cell information is displayed by row. Default \code{FALSE}.}
    \item{\code{showCellLabel,showFeatureLabel}}{Logical, whether to show cell barcodes,
gene symbols or factor names. Default \code{TRUE} for gene/factors but
\code{FALSE} for cells.}
    \item{\code{cellAnnColList,featureAnnColList}}{List object, with each element a
named vector of R-interpretable color code. The names of the list elements
are used for matching the annotation variable names. The names of the colors
in the vectors are used for matching the levels of a variable (factor object,
categorical). Default \code{NULL} generates ggplot-flavor categorical colors.}
    \item{\code{scale}}{Logical, whether to take z-score to scale and center gene
expression. Applied after \code{dataScaleFunc}. Default \code{FALSE}.}
    \item{\code{trim}}{Numeric vector of two values. Limit the z-score value into this
range when \code{scale = TRUE}. Default \code{c(-2, 2)}.}
    \item{\code{baseSize}}{One-parameter control of all text sizes. Individual text
element sizes can be controlled by other size arguments. "Title" sizes are
2 points larger than "text" sizes when being controlled by this.}
    \item{\code{cellTextSize,featureTextSize,legendTextSize}}{Size of cell barcode
labels, gene/factor labels, or legend values. Default \code{NULL}.}
    \item{\code{cellTitleSize,featureTitleSize,legendTitleSize}}{Size of titles of the
cell slices, gene/factor slices, or the legends. Default \code{NULL}.}
    \item{\code{viridisOption,viridisDirection}}{See argument \code{option} and
\code{direction} of \code{\link[viridisLite]{viridis}}. Default \code{"A"}
and \code{-1}.}
    \item{\code{RColorBrewerOption}}{When \code{scale = TRUE}, heatmap color will be
mapped with \code{\link[RColorBrewer]{brewer.pal}}. This is passed to
\code{name}. Default \code{"RdBu"}.}
  }}
}
\value{
A \link[ComplexHeatmap]{HeatmapList-class} object.
}
\description{
Create heatmap for showing top marker expression in conditions
}
\examples{
defaultCluster(pbmc) <- pbmcPlot$leiden_cluster
pbmc <- normalize(pbmc)
plotMarkerHeatmap(pbmc, deg.marker)
}
