% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import.R
\name{readLiger}
\alias{readLiger}
\title{Read liger object from RDS file}
\usage{
readLiger(
  filename,
  dimredName = "tsne_coords",
  clusterName = "clusters",
  h5FilePath = NULL,
  update = TRUE
)
}
\arguments{
\item{filename}{Path to an RDS file of a \code{liger} object of old versions.}

\item{dimredName}{The name of variable in \code{cellMeta} slot to store the
dimensionality reduction matrix, which originally located in
\code{tsne.coords} slot. Default \code{"tsne.coords"}.}

\item{clusterName}{The name of variable in \code{cellMeta} slot to store the
clustering assignment, which originally located in \code{clusters} slot.
Default \code{"clusters"}.}

\item{h5FilePath}{Named list, to specify the path to the H5 file of each
dataset if location has been changed. Default \code{NULL} looks at the file
paths stored in object.}

\item{update}{Logical, whether to update an old (<=1.0.0) \code{liger} object
to the currect version of structure. Default \code{TRUE}.}
}
\value{
New version of \linkS4class{liger} object
}
\description{
This file reads a liger object stored in RDS files under all kinds of types.
1. A \linkS4class{liger} object with in-memory data created from package
version since 1.99. 2. A liger object with on-disk H5 data associated, where
the link to H5 files will be automatically restored. 3. A liger object
created with older package version, and can be updated to the latest data
structure by default.
}
\examples{
# Save and read regular current-version liger object
tempPath <- tempfile(fileext = ".rds")
saveRDS(pbmc, tempPath)
pbmc <- readLiger(tempPath, dimredName = NULL)

# Save and read H5-based liger object
h5Path <- system.file("extdata/ctrl.h5", package = "rliger")
h5tempPath <- tempfile(fileext = ".h5")
file.copy(from = h5Path, to = h5tempPath)
lig <- createLiger(list(ctrl = h5tempPath))
tempPath <- tempfile(fileext = ".rds")
saveRDS(lig, tempPath)
lig <- readLiger(tempPath)

\dontrun{
# Read a old liger object <= 1.0.1
# Assume the dimensionality reduction method applied was UMAP
# Assume the clustering was derived with Louvain method
lig <- readLiger(
    filename = "path/to/oldLiger.rds",
    dimredName = "UMAP",
    clusterName = "louvain",
    update = TRUE
)
}
}
