% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KrigingClass.R
\name{print.Kriging}
\alias{print.Kriging}
\title{Print the content of a \code{Kriging} object.}
\usage{
\method{print}{Kriging}(x, ...)
}
\arguments{
\item{x}{A (S3) \code{Kriging} Object.}

\item{...}{Ignored.}
}
\value{
String of printed object.
}
\description{
Print the content of a \code{Kriging} object.
}
\examples{
f <- function(x) 1 - 1 / 2 * (sin(12 * x) / (1 + x) + 2 * cos(7 * x) * x^5 + 0.7)
set.seed(123)
X <- as.matrix(runif(10))
y <- f(X)

k <- Kriging(y, X, "matern3_2")

print(k)
## same thing
k
}
\author{
Yann Richet \email{yann.richet@irsn.fr}
}
