% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NuggetKrigingClass.R
\name{logLikelihood.NuggetKriging}
\alias{logLikelihood.NuggetKriging}
\alias{logLikelihood,NuggetKriging,NuggetKriging-method}
\title{Get logLikelihood of NuggetKriging Model}
\usage{
\method{logLikelihood}{NuggetKriging}(object, ...)
}
\arguments{
\item{object}{An S3 NuggetKriging object.}

\item{...}{Not used.}
}
\value{
The logLikelihood computed for fitted
    \eqn{\boldsymbol{theta_alpha}}{\theta,\frac{\sigma^2}{\sigma^2+nugget}}.
}
\description{
Get logLikelihood of NuggetKriging Model
}
\examples{
f <- function(x) 1 - 1 / 2 * (sin(12 * x) / (1 + x) + 2 * cos(7 * x) * x^5 + 0.7)
set.seed(123)
X <- as.matrix(runif(10))
y <- f(X) + 0.1 * rnorm(nrow(X))

k <- NuggetKriging(y, X, kernel = "matern3_2", objective="LL")
print(k)

logLikelihood(k)
}
\author{
Yann Richet \email{yann.richet@irsn.fr}
}
