% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lc.R
\name{lc_image}
\alias{lc_image}
\title{Add static plot or custom image to the page}
\usage{
lc_image(data = list(), place = NULL, ..., chartId = NULL, with = NULL)
}
\arguments{
\item{data}{Name value pairs of properties, passed through the \code{\link{dat}} function. These
properties will be reevaluated on each \code{\link{updateCharts}} call.}

\item{place}{ID of a container, where to place new chart. Will be ignored if the chart already
exists. If not defined, the chart will be appended to the body of the web pages.}

\item{...}{Name-value pairs of properties that will be evaluated only once and then will remain
constant. These properties can still be changed later using the \code{\link{setProperties}} function.}

\item{chartId}{ID for the chart. All charts must have unique IDs. If a chart with the same ID already
exists, it will be replaced. If ID is not defined, it will be the same as
value of the \code{place} argument. And if both are not defined, the ID will be set to \code{ChartN},
where \code{N - 1} is the number of existing charts.}

\item{with}{A data set from which other properties should be taken. If the data set doesn't have a
column with the requested name, the variable will be searched for outside of the data set. Must be
a data.frame or a list.}
}
\description{
\code{lc_image} adds a graphical object to the page. It can be any graphical R object (for example,
objects of class 'ggplot') or image that is stored locally. Note: currently works only on Linux and iOS.
}
\section{Available properties}{

You can read more about different properties
\href{https://anders-biostat.github.io/linked-charts/rlc/tutorials/props.html}{here}.

One of \code{img} and \code{src} properties is required.
\itemize{
\item \code{img} - static plot to display. Anything that can be saved as png can be used here. .png image fill be saved to
a temporary directory (see \code{\link[base]{tempdir}}).
\item \code{src} - path to an already saved image. Can be an absolute path or a path relative to the current working directory.
If \code{img} is defined, this property will be ignored.
}

Global chart settings
\itemize{
\item \code{title} - title of the input block.
\item \code{width} - width of the chart in pixels. By default, width will be set to fit the content.
If width is defined and it's smaller than content's width, scrolling will be possible.
\item \code{heigth} - height of the chart in pixels. By default, height will be set to fit the content.
If height is defined and it's smaller than content's height, scrolling will be possible.
\item \code{paddings} - padding sizes in pixels. Must be a list with all the following fields:
\code{"top", "bottom", "left", "right"}.}
}

\examples{
\donttest{
library(ggplot2)
pl <- ggplot() + geom_point(aes(1:10, 1:10))

lc_image(dat(img = pl, 
   title = "Some plot", 
   paddings = list(top = 100, bottom = 100, left = 10, right = 10)))
}

}
