% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readLAS.r
\name{readlasdata}
\alias{readlasdata}
\title{Read data from a .las or .laz file}
\usage{
readlasdata(files, i = TRUE, r = TRUE, n = TRUE, d = TRUE, e = TRUE,
  c = TRUE, a = TRUE, u = TRUE, p = TRUE, rgb = TRUE, t = TRUE,
  filter = "")
}
\arguments{
\item{files}{filepath character string to the .las or .laz files}

\item{i}{logical. do you want to load the Intensity field? default: TRUE}

\item{r}{logical. do you want to load the ReturnNumber field? default: TRUE}

\item{n}{logical. do you want to load the NumberOfReturns field? default: TRUE}

\item{d}{logical. do you want to load the ScanDirectionFlag field? default: TRUE}

\item{e}{logical. do you want to load the EdgeOfFlightline field? default: TRUE}

\item{c}{logical. do you want to load the Classification field? default: TRUE}

\item{a}{logical. do you want to load the ScanAngle field? default: TRUE}

\item{u}{logical. do you want to load the UserData field? default: TRUE}

\item{p}{logical. do you want to load the PointSourceID field? default: TRUE}

\item{rgb}{logical. do you want to load R,G and B fields? default: TRUE}

\item{t}{logical. do you want to load gpstime fields? default: TRUE}

\item{filter}{character. filter data while reading the file (streaming filter) without
allocating any useless memory. (see Details).}
}
\value{
A \code{data.table}
}
\description{
Reads data from .las or .laz files in format 1 to 4 according to LAS specifications and returns
a \code{data.table} labeled according to LAS specifications. See the ASPRS documentation for the
\href{http://www.asprs.org/a/society/committees/standards/LAS_1_4_r13.pdf}{LAS file format}.
The optional logical parameters enables the user to save memory by choosing to load only the
fields they need. Indeed, data is loaded into the computer's memory (RAM) suboptimally because
R does not accommodate many different data types. Moreover, the function provides a streaming filter
to load only the points of interest into the memory without allocating any superfluous memory.
}
\details{
Because \code{rlas} relies on the well-known \code{LASlib} library written by Martin Isenburg
to read the binary files, the package also inherits the filter commands available in
\href{https://rapidlasso.com/lastools/}{LAStools}. To use these filters the user can pass the
common commands from \code{LAStools} into the parameter \code{'filter'}. Type \code{rlas:::lasfilterusage()} to
display the \code{LASlib} documentation and the available filters.\cr\cr
The filter works in two passes. First it streams the file without loading anything and counts
the number of points of interest. Then it allocates the necessary amount of memory and reads the file
a second time, and stores the points of interest in the computer's memory (RAM).
}
\examples{
lazfile <- system.file("extdata", "example.laz", package="rlas")

lasdata <- readlasdata(lazfile)
lasdata <- readlasdata(lazfile, filter = "-keep_first")
lasdata <- readlasdata(lazfile, filter = "-drop_intensity_below 80")
}
\seealso{
Other rlas: \code{\link{readlasheader}},
  \code{\link{writelas}}
}
