% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eval.R
\name{with_env}
\alias{with_env}
\alias{locally}
\title{Evaluate an expression within a given environment}
\usage{
with_env(env, expr)

locally(expr)
}
\arguments{
\item{env}{An environment within which to evaluate \code{expr}. Can be
an object with an \code{\link[=get_env]{get_env()}} method.}

\item{expr}{An expression to evaluate.}
}
\description{
These functions evaluate \code{expr} within a given environment (\code{env}
for \code{with_env()}, or the child of the current environment for
\code{locally}). They rely on \code{\link[=eval_bare]{eval_bare()}} which features a lighter
evaluation mechanism than base R \code{\link[base:eval]{base::eval()}}, and which also has
some subtle implications when evaluting stack sensitive functions
(see help for \code{\link[=eval_bare]{eval_bare()}}).
}
\details{
\code{locally()} is equivalent to the base function
\code{\link[base:local]{base::local()}} but it produces a much cleaner
evaluation stack, and has stack-consistent semantics. It is thus
more suited for experimenting with the R language.
}
\section{Life cycle}{


These functions are experimental. Expect API changes.
}

\examples{
# with_env() is handy to create formulas with a given environment:
env <- child_env("rlang")
f <- with_env(env, ~new_formula())
identical(f_env(f), env)

# Or functions with a given enclosure:
fn <- with_env(env, function() NULL)
identical(get_env(fn), env)


# Unlike eval() it doesn't create duplicates on the evaluation
# stack. You can thus use it e.g. to create non-local returns:
fn <- function() {
  g(get_env())
  "normal return"
}
g <- function(env) {
  with_env(env, return("early return"))
}
fn()


# Since env is passed to as_environment(), it can be any object with an
# as_environment() method. For strings, the pkg_env() is returned:
with_env("base", ~mtcars)

# This can be handy to put dictionaries in scope:
with_env(mtcars, cyl)
}
