% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check.R
\name{initial_check_article}
\alias{initial_check_article}
\alias{check_filenames}
\alias{check_structure}
\alias{check_unnecessary_files}
\alias{check_cover_letter}
\alias{check_title}
\alias{check_section}
\alias{check_abstract_before_intro}
\alias{check_spelling}
\alias{check_proposed_pkg}
\alias{check_packages_available}
\title{A single article check}
\usage{
initial_check_article(
  path,
  dic = "en_US",
  pkg,
  ...,
  ask = interactive(),
  logfile = file.path(path, "initial_checks.log")
)

check_filenames(path)

check_structure(path)

check_unnecessary_files(path)

check_cover_letter(path)

check_title(path, ignore = "")

check_section(path)

check_abstract_before_intro(path)

check_spelling(path, dic = "en_US", ...)

check_proposed_pkg(pkg, ask = interactive())

check_packages_available(path, ignore)
}
\arguments{
\item{path}{string, path to the directory that contains the .tex
file (Ideally, this directory should contain .bib, .Rmd, and
.tex with author names and two RJwrapper files:  RJwrapper.pdf
and RJwrapper.tex)}

\item{dic}{string, the dictionary used for spelling check. See
\code{dict} argument in \code{\link[hunspell:hunspell]{hunspell::hunspell()}}}

\item{pkg}{string, optional. The name of the proposed package (if
relevant), to be checked for activity on CRAN}

\item{...}{additional arguments for spelling check with
\link[hunspell:hunspell]{hunspell::hunspell}}

\item{ask}{logical, if \code{TRUE} then checks may ask the user for
interactive input of missing information.}

\item{logfile}{a connection for the output log, or a string with
the filename of the output log or \code{NULL} if no log should
be written}

\item{ignore}{The words to ignore in title check, use c(pkg, pkg, ...) for multiple quoted words}
}
\value{
list of all results (see \code{\link{log_error}} for
details). You can use \code{unlist()} to get a character vector
of the result statuses.
}
\description{
A single article check
}
\details{
Folder structure checks:
\itemize{
\item \code{check_filenames()}: the three files (.bib, .Rmd, and .tex) all present and have consistent names
\item \code{check_structure()}: check validity of all filenames and depth of the directory structure
\item \code{check_unnecessary_files()}: the template file (i.e., RJtemplate.tex) is not included in the directory
\item \code{check_cover_letter()}: a motivational letter
}

Content checks:
\itemize{
\item \code{check_title()}: article title is in title case
\item \code{check_section()}: section sections are in sentence case
\item \code{check_abstract_before_intro()}: abstract comes before the introduction section
\item \code{check_spelling()}: potential spelling mistakes
\item \code{check_proposed_pkg()}: package proposed in the paper is on CRAN
\item \code{check_packages_available()}: packages mentioned in the article are available on CRAN
}

See \code{vignette("create_article", package = "rjtools")} for how to use the check functions
}
\examples{
your_article_path <- system.file("sample-article", package = "rjtools")
if (interactive()) initial_check_article(your_article_path)

}
