% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset_help.R
\name{rivernetwork}
\alias{rivernetwork}
\alias{rivernetwork-class}
\title{The "rivernetwork" Class}
\description{
A class that holds spatial coordinates for river networks, as well as network topology and attributes.
}
\details{
Created by \link{line2network} from an input line shapefile.  Contains all information for network distance calculation, plotting, etc. in the 'riverdist' package.

Plotting methods are described in \link{plot.rivernetwork}.
}
\section{Elements}{
 
 \describe{
   \item{\code{sp}:}{Object of class \code{"SpatialLinesDataFrame"} from package 'sp'; see \link[sp]{SpatialLinesDataFrame-class}.  This is the original object as read by \link[rgdal]{readOGR}, and is preserved to maintain plotting capability.}
   \item{\code{lines}:}{Object of class \code{"list"}.  Each list element is a matrix of XY coordinates of the vertices of a single river segment.}
   \item{\code{connections}:}{Object of class \code{"matrix"}, with \code{"numeric"} elements.  Defined as a square matrix, with elements describing the type of connection detected between line segments.
     \itemize{
     \item A value of 1 in element \code{[i,j]} indicates that the beginning of segment \code{i} is connected to the beginning of segment \code{j}.
     \item A value of 2 in element \code{[i,j]} indicates that the beginning of segment \code{i} is connected to the end of segment \code{j}.
     \item A value of 3 in element \code{[i,j]} indicates that the end of segment \code{i} is connected to the beginning of segment \code{j}.
     \item A value of 4 in element \code{[i,j]} indicates that the end of segment \code{i} is connected to the end of segment \code{j}.
     \item A value of 5 in element \code{[i,j]} indicates that segments \code{i} and \code{j} are connected at both beginning and end.
     \item A value of 6 in element \code{[i,j]} indicates that the beginning of segment \code{i} is connected to the end of segment \code{j}, and the end of segment \code{i} is connected to the beginning of segment \code{j}.
     \item A value of NA in element \code{[i,j]} indicates that segments \code{i} and \code{j} are not connected.}}
   \item{\code{lengths}:}{Vector of class \code{"numeric"}.  Defined as the calculated total lengths of each river segment.}
   \item{\code{names}:}{Vector of class \code{"character"}.  Defined as the names of each river segment.}
   \item{\code{mouth}:}{Object of class \code{"list"}, with two elements.  Element \code{mouth.seg} gives the segment number of the mouth (lowest point) of the river network, and \code{mouth.vert} gives the vertex number.}
   \item{\code{sequenced}:}{\code{"logical"}: has value of TRUE if line vertices have been stored in upstream sequence using \link{sequenceverts}.}
   \item{\code{tolerance}:}{\code{"numeric"}: the spatial tolerance that was used in determining river segment endpoint connectivity; see \link{line2network}, \link{splitsegments}.}
   \item{\code{units}:}{\code{"character"}: the spatial units detected from the input shapefile.}
   \item{\code{lineID}:}{Object of class \code{"data.frame"} establishing the relationship between river segments as stored in the \code{sp} and \code{lines} elements, and is used for updating the \code{sp} element during river network editing in \link{dissolve}, \link{splitsegments}, \link{sequenceverts}, \link{trimriver}, and \link{trimtopoints}.
   \itemize{
     \item \code{rivID} gives the list element number of each river segment in \code{lines}.  This is the same number that is used for segment numbering in river locations.
     \item \code{sp_line} gives the corresponding list element in \code{sp@lines}.
     \item \code{sp_seg} gives the corresponding list element in \code{sp@lines[[]]@Lines}.
     }}
   \item{\code{braided}:}{\code{"logical"}: Has value of \code{TRUE} if \link{checkbraidedTF} has detected braiding, \code{FALSE} if no braiding has been detected, and \code{NA} if braiding has not yet been checked.}
   \item{\code{cumuldist}:}{List of class \code{"numeric"}: Each element is a vector of cumulative distances along each river segment, beginning with 0.}
   \item{\code{segroutes}:}{Object of class \code{"list"}, with each element defined as a vector of class \code{"numeric"}, describing the route from the mouth segment to the specific segment.  This element only exists if \link{buildsegroutes} has been run, and can greatly speed up route and distance calculation.}
   \item{\code{distlookup}:}{List of three matrices, of class \code{"numeric"} or \code{"logical"}.  Element \code{[i,j]} of each matrix corresponds to
  the route between segment \code{i} and \code{j}.  The
  \code{distlookup$middist} matrix gives the total distance of the "middle"
  of each route (between the starting and ending segments"), and the
  \code{distlookup$starttop} and \code{distlookup$endtop} matrices have value
  \code{TRUE}, \code{FALSE}, or \code{NA} if the segments at the beginning or
  end of the route are connected to the rest of the route at the top of the
  coordinate matrix, bottom of the coordinate matrix, or if the route is
  contained to just one segment, respectively. }
  }
}

\author{
Matt Tyers
}
