% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comp_prob_prob.R
\name{comp_fart}
\alias{comp_fart}
\title{Compute a decision's false alarm rate from its specificity.}
\usage{
comp_fart(spec)
}
\arguments{
\item{spec}{The decision's specificity value \code{\link{spec}} as a probability.}
}
\value{
The decision's false alarm rate \code{\link{fart}} as a probability.
}
\description{
\code{comp_fart} is a conversion function that takes a specificity \code{\link{spec}}
-- given as a probability (i.e., a numeric value in the range from 0 to 1) --
as its input, and returns the corresponding false alarm rate \code{\link{fart}}
-- also as a probability -- as its output.
}
\details{
The false alarm rate \code{\link{fart}} and specificity \code{\link{spec}}
are complements (\code{fart = (1 - spec)}) and both features of
the decision process (e.g., a diagnostic test).

The function \code{comp_fart} is complementary to the conversion function
\code{\link{comp_spec}} and uses the generic function
\code{\link{comp_complement}}.
}
\examples{
comp_fart(2)                       # => NA + warning (beyond range)
comp_fart(1/3)                     # => 0.6666667
comp_fart(comp_complement(0.123))  # => 0.123

}
\seealso{
\code{\link{comp_complement}} computes a probability's complement;
\code{\link{is_complement}} verifies probability complements;
\code{\link{comp_prob}} computes current probability information;
\code{\link{prob}} contains current probability information;
\code{\link{is_prob}} verifies probabilities.

Other functions computing probabilities: \code{\link{comp_FDR}},
  \code{\link{comp_FOR}}, \code{\link{comp_NPV}},
  \code{\link{comp_PPV}}, \code{\link{comp_accu_freq}},
  \code{\link{comp_accu_prob}}, \code{\link{comp_acc}},
  \code{\link{comp_comp_pair}},
  \code{\link{comp_complement}},
  \code{\link{comp_complete_prob_set}},
  \code{\link{comp_err}}, \code{\link{comp_mirt}},
  \code{\link{comp_ppod}}, \code{\link{comp_prob_freq}},
  \code{\link{comp_prob}}, \code{\link{comp_sens}},
  \code{\link{comp_spec}}
}
\concept{functions computing probabilities}
