% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/init_prob.R
\docType{data}
\name{PPV}
\alias{PPV}
\alias{precision}
\title{The positive predictive value of a decision process or diagnostic procedure.}
\format{An object of class \code{numeric} of length 1.}
\usage{
PPV
}
\description{
\code{PPV} defines some decision's positive predictive value (PPV):
The conditional probability of the condition being \code{TRUE}
provided that the decision is positive.
}
\details{
Understanding or obtaining the positive predictive value \code{PPV}:

\itemize{

\item Definition:
  \code{PPV} is the conditional probability
  for the condition being \code{TRUE}
  given a positive decision:

\code{PPV = p(condition = TRUE | decision = positive)}

or the probability of a positive decision being correct.

\item Perspective:
  \code{PPV} further classifies
  the subset of \code{\link{dec_pos}} individuals
  by condition (\code{PPV = hi/dec_pos = hi/(hi + fa)}).

\item Alternative names:
  \code{precision}

\item Relationships:

a. \code{PPV} is the complement of the
  false discovery or false detection rate \code{\link{FDR}}:

\code{PPV = 1 - FDR}

b. \code{PPV} is the opposite conditional probability
  -- but not the complement --
  of the sensitivity \code{\link{sens}}:

\code{sens = p(decision = positive | condition = TRUE)}

\item In terms of frequencies,
  \code{PPV} is the ratio of
  \code{\link{hi}} divided by \code{\link{dec_pos}}
  (i.e., \code{\link{hi} + \link{fa}}):

\code{PPV = hi/dec_pos = hi/(hi + fa)}

\item Dependencies:
  \code{PPV} is a feature of a decision process
  or diagnostic procedure and
  -- similar to the sensitivity \code{\link{sens}} --
  a measure of correct decisions (positive decisions
  that are actually TRUE).

However, due to being a conditional probability,
  the value of \code{PPV} is not intrinsic to
  the decision process, but also depends on the
  condition's prevalence value \code{\link{prev}}.

}
}
\examples{
PPV <- .55     # sets a positive predictive value of 55\%
PPV <- 55/100  # (condition = TRUE) for 55 out of 100 people with (decision = positive)
is_prob(PPV)   # TRUE

}
\references{
Consult \href{https://en.wikipedia.org/wiki/Positive_and_negative_predictive_values}{Wikipedia} for additional information.
}
\seealso{
\code{\link{comp_PPV}} computes \code{PPV};
\code{\link{prob}} contains current probability information;
\code{\link{comp_prob}} computes current probability information;
\code{\link{num}} contains basic numeric parameters;
\code{\link{init_num}} initializes basic numeric parameters;
\code{\link{comp_freq}} computes current frequency information;
\code{\link{is_prob}} verifies probabilities.

Other probabilities: \code{\link{FDR}}, \code{\link{FOR}},
  \code{\link{NPV}}, \code{\link{acc}}, \code{\link{err}},
  \code{\link{fart}}, \code{\link{mirt}},
  \code{\link{ppod}}, \code{\link{prev}},
  \code{\link{sens}}, \code{\link{spec}}
}
\concept{probabilities}
\keyword{datasets}
