% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/init_freq_num.R
\docType{data}
\name{freq}
\alias{freq}
\title{List current frequency information.}
\format{An object of class \code{list} of length 11.}
\usage{
freq
}
\description{
\code{freq} is a list of named numeric variables
containing 11 frequencies:
}
\details{
\enumerate{

\item the population size \code{\link{N}}

\item the number of cases for which \code{\link{cond.true}}
 \item the number of cases for which \code{\link{cond.false}}

\item the number of cases for which \code{\link{dec.pos}}
 \item the number of cases for which \code{\link{dec.neg}}

\item the number of cases for which \code{\link{dec.cor}}
 \item the number of cases for which \code{\link{dec.err}}

\item the number of true positives, or hits \code{\link{hi}}
 \item the number of false negatives, or misses \code{\link{mi}}
 \item the number of false positives, or false alarms \code{\link{fa}}
 \item the number of true negatives, or correct rejections \code{\link{cr}}

}

These frequencies are computed from basic parameters
(contained in \code{\link{num}}) and computed by using
\code{\link{comp_freq}}.

The list \code{freq} is the frequency counterpart
to the list containing probability information \code{\link{prob}}.

Natural frequencies are always expressed in
relation to the current population of
size \code{\link{N}}.

Key relationships:

\enumerate{

\item to probabilities:
A population of \code{\link{N}} individuals can be split into 2 subsets
in 2 different ways:

\enumerate{
  \item by condition:
  The frequency \code{\link{cond.true}} depends on the prevalence \code{\link{prev}}
  and
  the frequency \code{\link{cond.false}} depends on the prevalence's complement \code{(1 - \link{prev})}.

\item by decision:
  The frequency \code{\link{dec.pos}} depends on the proportion of positive decisions \code{\link{ppod}}
  and
  the frequency \code{\link{dec.neg}} depends on the proportion of negative decisions \code{(1 - \link{ppod})}.

}

The population size \code{\link{N}} is a free parameter (independent of the
essential probabilities \code{\link{prev}}, \code{\link{sens}}, and \code{\link{spec}}).

If \code{\link{N}} is unknown, a suitable minimum value can be computed by \code{\link{comp_min_N}}.

\item to other frequencies:
  In a population of size \code{\link{N}}
  the following relationships hold:

\itemize{

\item \code{\link{N} = \link{cond.true} + \link{cond.false}} (by condition)

\item \code{\link{N} = \link{dec.pos} + \link{dec.neg}} (by decision)

\item \code{\link{N} = \link{dec.cor} + \link{dec.err}} (by correspondence of decision to condition)

\item \code{\link{N} = \link{hi} + \link{mi} + \link{fa} + \link{cr}} (by condition x decision)
  }

}

Visualizations of the current frequency information
are provided by \code{\link{plot_tree}} and
\code{\link{plot_mosaic}}.
}
\examples{
freq <- comp_freq()  # => initialize freq to default parameters
freq                 # => show current values
length(freq)         # => 11


}
\seealso{
\code{\link{comp_freq}} computes current frequency information;
\code{\link{num}} contains basic numeric variables;
\code{\link{init_num}} initializes basic numeric variables;
\code{\link{prob}} contains current probability information;
\code{\link{num}} contains basic numeric parameters;
\code{\link{init_num}} initializes basic numeric parameters;
\code{\link{txt}} contains current text information;
\code{\link{init_txt}} initializes text information;
\code{\link{pal}} contains current color information;
\code{\link{init_pal}} initializes color information.

Other lists containing current scenario information: \code{\link{accu}},
  \code{\link{num}}, \code{\link{pal}}, \code{\link{prob}},
  \code{\link{txt}}
}
\keyword{datasets}
