% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/init_prob_num.R
\name{comp_prob}
\alias{comp_prob}
\title{Compute probabilities from (3 essential) probabilities.}
\usage{
comp_prob(prev = num$prev, sens = num$sens, mirt = NA, spec = num$spec,
  fart = NA, tol = 0.01)
}
\arguments{
\item{prev}{The condition's prevalence value \code{\link{prev}}
(i.e., the probability of the condition being \code{TRUE}).}

\item{sens}{The decision's sensitivity value \code{\link{sens}}
(i.e., the conditional probability of a positive decision
provided that the condition is \code{TRUE}).
\code{sens} is optional when its complement \code{\link{mirt}} is provided.}

\item{mirt}{The decision's miss rate value \code{\link{mirt}}
(i.e., the conditional probability of a negative decision
provided that the condition is \code{TRUE}).
\code{mirt} is optional when its complement \code{\link{sens}} is provided.}

\item{spec}{The decision's specificity value \code{\link{spec}}
(i.e., the conditional probability
of a negative decision provided that the condition is \code{FALSE}).
\code{spec} is optional when its complement \code{\link{fart}} is provided.}

\item{fart}{The decision's false alarm rate \code{\link{fart}}
(i.e., the conditional probability
of a positive decision provided that the condition is \code{FALSE}).
\code{fart} is optional when its complement \code{\link{spec}} is provided.}

\item{tol}{A numeric tolerance value for \code{\link{is_complement}}.
Default: \code{tol = .01}.}
}
\value{
A list \code{\link{prob}} containing 10 probability values.
}
\description{
\code{comp_prob} computes current probability information
from 3 essential probabilities
(\code{\link{prev}},
\code{\link{sens}} or \code{\link{mirt}},
\code{\link{spec}} or \code{\link{fart}}).
It returns a list of 10 probabilities \code{\link{prob}}
as its output.
}
\details{
\code{comp_prob} assumes that a sufficient and
consistent set of essential probabilities
(i.e., \code{\link{prev}} and
either \code{\link{sens}} or its complement \code{\link{mirt}}, and
either \code{\link{spec}} or its complement \code{\link{fart}})
is provided.

\code{comp_prob} computes and returns a full set of basic and
various derived probabilities (e.g.,
the probability of a positive decision \code{\link{ppod}},
the predictive values \code{\link{PPV}} and \code{\link{NPV}}, as well
as their complements \code{\link{FDR}} and \code{\link{FOR}})
in its output of a list \code{\link{prob}}.

Extreme probabilities (sets containing two or more
probabilities of 0 or 1) may yield unexpected values
(e.g., predictive values \code{\link{PPV}} or \code{\link{NPV}}
turning \code{NaN} when \code{\link{is_extreme_prob_set}}
evaluates to \code{TRUE}).

\code{comp_prob} is the probability counterpart to the
frequency function \code{\link{comp_freq}}.

Key relationships:

\itemize{

\item Other functions translating between representational formats:

\enumerate{

\item \code{comp_prob_prob} (defined here) is
   a wrapper function for \code{\link{comp_prob}} and
   an analog to 3 other format conversion functions:

\item \code{\link{comp_prob_freq}} computes
   current \emph{probability} information contained in \code{\link{prob}}
   from 4 essential frequencies
   (\code{\link{hi}}, \code{\link{mi}}, \code{\link{fa}}, \code{\link{cr}}).

\item \code{\link{comp_freq_prob}} computes
   current \emph{frequency} information contained in \code{\link{freq}}
   from 3 essential probabilities
   (\code{\link{prev}}, \code{\link{sens}}, \code{\link{spec}}).

\item \code{\link{comp_freq_freq}} computes
   current \emph{frequency} information contained in \code{\link{freq}}
   from 4 essential frequencies
   (\code{\link{hi}}, \code{\link{mi}}, \code{\link{fa}}, \code{\link{cr}}).

}

\item Two perspectives:

A population of \code{\link{N}} individuals can be split into 2 subsets
in 2 different ways:

\enumerate{

\item by condition:

The frequency \code{\link{cond.true}} depends on the prevalence \code{\link{prev}}
   and
   the frequency \code{\link{cond.false}} depends on the prevalence's complement \code{1 - \link{prev}}.

\item by decision:

The frequency \code{\link{dec.pos}} depends on the proportion of positive decisions \code{\link{ppod}}
   and
   the frequency \code{\link{dec.neg}} depends on the proportion of negative decisions \code{1 - \link{ppod}}.

}

The population size \code{\link{N}} is a free parameter (independent of the
essential probabilities \code{\link{prev}}, \code{\link{sens}}, and \code{\link{spec}}).

If \code{\link{N}} is unknown (\code{NA}), a suitable minimum value can be computed by \code{\link{comp_min_N}}.

\item Combinations of frequencies:

In a population of size \code{\link{N}} the following relationships hold:

\enumerate{

\item \code{\link{N} = \link{cond.true} + \link{cond.false} = (\link{hi} + \link{mi}) + (\link{fa} + \link{cr})} (by condition)

\item \code{\link{N} = \link{dec.pos} + \link{dec.neg} = (\link{hi} + \link{fa}) + (\link{mi} + \link{cr})} (by decision)

\item \code{\link{N} = \link{hi} + \link{mi} + \link{fa} + \link{cr}} (by condition x decision)

}

The two perspectives (by condition vs. by decision) combine the 4 essential frequencies
  (i.e., \code{\link{hi}}, \code{\link{mi}}, \code{\link{fa}}, \code{\link{cr}})
  in 2 different ways.

\item Defining probabilities in terms of frequencies:

Probabilities \emph{are} numbers from 0 to 1 and determine, describe, or are defined as relationships between frequencies.
The following probabilities can be computed as ratios between frequencies:

\enumerate{

\item prevalence \code{\link{prev}}:

\code{\link{prev} = \link{cond.true}/\link{N}  =  (\link{hi} + \link{mi}) / (\link{hi} + \link{mi} + \link{fa} + \link{cr})}

\item sensitivity \code{\link{sens}}:

\code{\link{sens} = \link{hi}/\link{cond.true}  =  \link{hi} / (\link{hi} + \link{mi})  =  (1 - \link{mirt})}

\item miss rate \code{\link{mirt}}:

\code{\link{mirt} = \link{mi}/\link{cond.true}  =  \link{mi} / (\link{hi} + \link{mi})  =  (1 - \link{sens})}

\item specificity \code{\link{spec}}:

\code{\link{spec} = \link{cr}/\link{cond.false}  =  \link{cr} / (\link{fa} + \link{cr})  =  (1 - \link{fart})}

\item false alarm rate \code{\link{fart}}:

\code{\link{fart} = \link{fa}/\link{cond.false}  =  \link{fa} / (\link{fa} + \link{cr})  =  (1 - \link{spec})}



\item proportion of positive decisions \code{\link{ppod}}:

\code{\link{ppod} = \link{dec.pos}/\link{N}  =  (\link{hi} + \link{fa}) / (\link{hi} + \link{mi} + \link{fa} + \link{cr})}

\item positive predictive value \code{\link{PPV}}:

\code{\link{PPV} = \link{hi}/\link{dec.pos}  =  \link{hi} / (\link{hi} + \link{fa})  =  (1 - \link{FDR})}

\item false detection rate \code{\link{FDR}}:

\code{\link{FDR} = \link{fa}/\link{dec.pos}  =  \link{fa} / (\link{hi} + \link{fa})  =  (1 - \link{PPV})}

\item negative predictive value \code{\link{NPV}}:

\code{\link{NPV} = \link{cr}/\link{dec.neg}  =  \link{cr} / (\link{mi} + \link{cr})  =  (1 - \link{FOR})}

\item false omission rate \code{\link{FOR}}:

\code{\link{FOR} = \link{mi}/\link{dec.neg}  =  \link{mi} / (\link{mi} + \link{cr})  =  (1 - \link{NPV})}

}

}
}
\examples{
# Basics:
comp_prob(prev = .11, sens = .88, spec = .77)                        # => ok: PPV = 0.3210614
comp_prob(prev = .11, sens = NA, mirt = .12, spec = NA, fart = .23)  # => ok: PPV = 0.3210614
comp_prob()          # => ok, using current defaults
length(comp_prob())  # => 10 probabilities

# Ways to work:
comp_prob(.99, sens = .99, spec = .99)              # => ok: PPV = 0.999898
comp_prob(.99, sens = .90, spec = NA, fart = .10)   # => ok: PPV = 0.9988789

# Watch out for extreme cases:
comp_prob(1, sens = 0, spec = 1)      # => ok, but with warnings (as PPV & FDR are NaN)
comp_prob(1, sens = 0, spec = 0)      # => ok, but with warnings (as PPV & FDR are NaN)
comp_prob(1, sens = 0, spec = NA, fart = 0)  # => ok, but with warnings (as PPV & FDR are NaN)
comp_prob(1, sens = 0, spec = NA, fart = 1)  # => ok, but with warnings (as PPV & FDR are NaN)

# Watch out for extreme cases:
comp_prob(1, sens = 0, spec = 1)      # => ok, but with warnings (as PPV & FDR are NaN)
comp_prob(1, sens = 0, spec = 0)      # => ok, but with warnings (as PPV & FDR are NaN)
comp_prob(1, sens = 0, spec = NA, fart = 0)  # => ok, but with warnings (as PPV & FDR are NaN)
comp_prob(1, sens = 0, spec = NA, fart = 1)  # => ok, but with warnings (as PPV & FDR are NaN)

comp_prob(1, sens = 1, spec = 0)      # => ok, but with warnings (as NPV & FOR are NaN)
comp_prob(1, sens = 1, spec = 1)      # => ok, but with warnings (as NPV & FOR are NaN)
comp_prob(1, sens = 1, spec = NA, fart = 0)  # => ok, but with warnings (as NPV & FOR are NaN)
comp_prob(1, sens = 1, spec = NA, fart = 1)  # => ok, but with warnings (as NPV & FOR are NaN)

# Ways to fail:
comp_prob(NA, 1, 1, NA)  # => only warning: invalid set (prev not numeric)
comp_prob(8,  1, 1, NA)  # => only warning: prev no probability
comp_prob(1,  8, 1, NA)  # => only warning: sens no probability
comp_prob(1,  1, 1,  1)  # => only warning: is_complement not in tolerated range


}
\seealso{
\code{\link{prob}} contains current probability information;
\code{\link{num}} contains basic numeric parameters;
\code{\link{init_num}} initializes basic numeric parameters;
\code{\link{pal}} contains current color information;
\code{\link{txt}} contains current text information;
\code{\link{freq}} contains current frequency information;
\code{\link{comp_freq}} computes frequencies from probabilities;
\code{\link{is_valid_prob_set}} verifies sets of probability inputs;
\code{\link{is_extreme_prob_set}} verifies sets of extreme probabilities;
\code{\link{comp_min_N}} computes a suitable minimum population size \code{\link{N}};
\code{\link{comp_freq_freq}} computes current frequency information from (4 essential) frequencies;
\code{\link{comp_freq_prob}} computes current frequency information from (3 essential) probabilities;
\code{\link{comp_prob_freq}} computes current probability information from (4 essential) frequencies;
\code{\link{comp_prob_prob}} computes current probability information from (3 essential) probabilities.

Other functions computing probabilities: \code{\link{comp_FDR}},
  \code{\link{comp_FOR}}, \code{\link{comp_NPV}},
  \code{\link{comp_PPV}}, \code{\link{comp_accu}},
  \code{\link{comp_acc}}, \code{\link{comp_comp_pair}},
  \code{\link{comp_complement}},
  \code{\link{comp_complete_prob_set}},
  \code{\link{comp_fart}}, \code{\link{comp_mirt}},
  \code{\link{comp_ppod}}, \code{\link{comp_prob_freq}},
  \code{\link{comp_sens}}, \code{\link{comp_spec}}
}
