% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/margstd-utils.R
\name{summary.margstd_boot}
\alias{summary.margstd_boot}
\title{Summary for models using marginal standardization}
\usage{
\method{summary}{margstd_boot}(
  object,
  dispersion = NULL,
  correlation = FALSE,
  symbolic.cor = FALSE,
  level = 0.95,
  bootrepeats = 1000,
  bootci = c("bca", "normal", "nonpar"),
  ...
)
}
\arguments{
\item{object}{Model}

\item{dispersion}{Not used}

\item{correlation}{Not used}

\item{symbolic.cor}{Not used}

\item{level}{Confidence level, defaults to \code{0.95}.}

\item{bootrepeats}{Bootstrap repeats for standard errors. Defaults to 1000.
Consider increasing.}

\item{bootci}{Type of bootstrap confidence interval:
\itemize{
\item \code{"bca"} Default. Parametric BCa (bias-corrected accelerated)
confidence intervals.
\item \code{"normal"} Parametric normality-based confidence intervals,
which require lower repeat numbers but are less accurate and
may result in invalid results for ratios.
\item \code{"nonpar"} Non-parametric BCa confidence intervals,
which should be used with caution because of the risk
of sparse-data bias with non-parametric bootstrapping.
}}

\item{...}{Not used}
}
\value{
Model summary (list)
}
\description{
Summary for models using marginal standardization
}
