% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{with.pkg_ref}
\alias{with.pkg_ref}
\title{Evaluate an expression in the context of a pkg_ref}
\usage{
\method{with}{pkg_ref}(data, expr, ...)
}
\arguments{
\item{data}{data to use for constructing an environment. For the
    default \code{with} method this may be an environment, a list, a
    data frame, or an integer as in \code{sys.call}. For \code{within},
    it can be a list or a data frame.}

\item{expr}{expression to evaluate; particularly for \code{within()}
    often a \dQuote{compound} expression, i.e., of the form \preformatted{   {
     a <- somefun()
     b <- otherfun()
     .....
     rm(unused1, temp)
   }
}}

\item{...}{arguments to be passed to (future) methods.}
}
\value{
the value of the evaluated expr.
}
\description{
\code{pkg_ref} objects are environments and can be passed to \code{with}
in much the same way. This specialized function makes sure that any fields
within the \code{pkg_ref} have been appropriately evaluated before trying
to execute the expression.
}
\keyword{internal}
