% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{colSumsCrossprod}
\alias{colSumsCrossprod}
\title{Apply crossprod and colSums}
\usage{
colSumsCrossprod(X, Y, transposeY)
}
\arguments{
\item{X}{A matrix with dimensions k*n. Hence the result of \code{colSums(X)} has length n.}

\item{Y}{A matrix with dimenions n*m. Can be a matrix with dimension m*n but then \code{transposeY} should be \code{TRUE}.}

\item{transposeY}{Logical. If \code{TRUE} transpose Y before matrix multiplication.}
}
\value{
A vector of length m.
}
\description{
Fast computation of crossprod(colSums(X),Y)
}
\examples{
x <- matrix(1:8,ncol=2)
y <- matrix(1:16,ncol=8)
colSumsCrossprod(x,y,0)

x <- matrix(1:8,ncol=2)
y <- matrix(1:16,ncol=2)
colSumsCrossprod(x,y,1)
}
\author{
Thomas Alexander Gerds <tag@biostat.ku.dk>
}

