% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metadata.R
\name{iquery}
\alias{iquery}
\title{Query Data Objects and Collections in iRODS}
\usage{
iquery(
  query,
  limit = 100,
  offset = 0,
  type = c("general", "specific"),
  case_sensitive = TRUE,
  distinct = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{query}{GeneralQuery for searching the iCAT database.}

\item{limit}{Maximum number of rows to return. Defaults to 100.}

\item{offset}{Number of rows to skip for paging. Defaults to 0.}

\item{type}{Type of query: 'general' (the default) or 'specific'.}

\item{case_sensitive}{Whether the string matching in the query is case sensitive.
Defaults to \code{TRUE}.}

\item{distinct}{Whether only distinct rows should be listed. Defaults to \code{TRUE}.}

\item{verbose}{Whether information should be printed about the HTTP request and response.}
}
\value{
A dataframe with one row per result and one column per requested attribute,
with "size" and "time" columns parsed to the right type.

Invisibly, the HTTP response.
}
\description{
Use SQL-like expressions to query data objects and collections based on
different properties. Read more about queries by looking at the iCommands
equivalent \code{iquest} in the \href{https://docs.irods.org/master/icommands/user/#iquest}{iRODS Docs}.
}
\examples{
\dontshow{if (is_irods_demo_running()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
is_irods_demo_running()

# demonstration server (requires Bash, Docker and Docker-compose)
# use_irods_demo()

# connect project to server
create_irods("http://localhost/irods-rest/0.9.3", "/tempZone/home")

# authentication
iauth("rods", "rods")

# some data
foo <- data.frame(x = c(1, 8, 9), y = c("x", "y", "z"))

# store
isaveRDS(foo, "foo.rds")

# add metadata
imeta(
  "foo.rds",
  "data_object",
  operations =
    list(
      list(operation = "add", attribute = "bar", value = "baz")
  )
)

# search for objects by metadata
iquery("SELECT COLL_NAME, DATA_NAME WHERE META_DATA_ATTR_NAME LIKE 'bar\%'")

# delete object
irm("foo.rds", force = TRUE)
\dontshow{\}) # examplesIf}
}
\references{
https://docs.irods.org/master/icommands/user/#iquest

Use SQL-like expressions to query data objects and collections based on different properties.
}
\seealso{
\code{\link[=imeta]{imeta()}}
}
