% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist.R
\name{resize}
\alias{resize}
\title{Resize}
\usage{
resize(d, n)
}
\arguments{
\item{d}{Dist object representing the distribution.}

\item{n}{Numeric representing the desired size of the support.}
}
\value{
Dist giving the resized distribution.
}
\description{
Generic function to resize the support of the distribution in place. If the
distribution shrinks, the last \code{lenght(Dist) - n} elements are lost,
the rest are preserved. If it grows, the last \code{n - lenght(Dist)}
elements are zeroed.
}
\examples{
# Resizing invalid distribution
d <- Dist(5)
d <- resize(d, 3)
length(d) # 3

d <- resize(d, 8)
length(d) # 8

# Resizing valid distribution
d <- Dist(c(1, 2, 3, 4))
d <- resize(d, 2) # list(c(1, 2), 2, 3)
d
d <- resize(d, 4) # list(c(1, 2, 0, 0), 4, 3)
d
}
