% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/var-wt.R
\name{var_wt}
\alias{var_wt}
\title{Calculates the weighted variance}
\usage{
var_wt(x, wt, na.rm = FALSE)
}
\arguments{
\item{x}{numeric vector}

\item{wt}{weights}

\item{na.rm}{If \code{TRUE}, indices where \code{x} is NA will be removed}
}
\value{
A numeric vector containing weighted variance of the elements of \code{x}
}
\description{
Calculates the weighted variance
}
\examples{
x <- sample(1:10, size = 10, replace = TRUE)
x.weight <- seq(0, 1, length.out = 10)
var_wt(x, wt = x.weight)
}
