rim - R’s interface to Maxima
================

<!-- README.md is generated from README.Rmd. Please edit that file -->

[![](https://cranlogs.r-pkg.org/badges/rim)](https://CRAN.R-project.org/package=rim)
[![](https://cranlogs.r-pkg.org/badges/grand-total/rim)](https://CRAN.R-project.org/package=rim)

Development version of CRAN package. `rim` provides an interface to the
powerful and fairly complete maxima computer algebra system

This repository is a fork from RMaxima, the original version created by
Kseniia Shumelchyk and Hans W. Borcher
[shumelchyk/rmaxima](https://github.com/shumelchyk/rmaxima), which is
currently not maintained.

# Installation

``` r
install.packages("rim")
```

## Requirements

-   Maxima (<https://sourceforge.net/projects/maxima/>, tested with
    versions &gt;=5.42.1), needs to be on PATH

## Latest Version

If you want to install the latest version install the R package
`remotes` first and then install the package from this github repo:

``` r
install.packages("remotes")
remotes::install_github("rcst/rim")
```

# Usage

This section only demonstrate using the packages R-function directly
accessible to the user. On how to use the package’s `knitr` engine see
[this page](https://rcst.github.io/rim/).

``` r
library(rim)
```

``` r
maxima.start(restart = TRUE)
maxima.get("1+1;")
```

    ## (%o1) 2

``` r
r <- maxima.get("sum(1/x^2, x, 1, 10000)")
print(r)
```

    ## (%o2) 54714423173933343999582177160129362529870283624174963297531328605746589773430778183198620050736675427362803973347189596920858374826198299243875944018790714269022039209429246957120164226897122221467774889383041528298564231525726005885733604890567741863788282223101091820040246774500899582880738779441903043993446797207474982772365818204209418017874472746075929430402719315899195398091579911840793724334501466809497514690646349026417408657798612724412146815881907468466138871837138164123922629387751665906831009172724807380344362641581163733346203555718850891948260773752299205407726870601562897167876485357851589965396280602666157317110387959451092855487589490685186018122043775191659379508292628762992096830369387377564339210809700754302538398507252386941602236810441631669594849503782189852039566430411366575909380827769724447338940111761588124004276515786306137226537894846082264669311720594628838458236534704442082294084133019729052294375893488930238771136044176775587032445127166320941961770547230342282891720711094680202323745272645863298738706071559533479377820073676651860866476014981202902915165425984274917243253526013326104533936418682251997405429350574846738597941596465847889444363702434675773342527460766142607487599035002858371082612263524228218717418382091490999753564503938592826918552223027205803181181888741408228059697739547051812861769394298478975745066997066788703540179782594827175983300181264325697248430726629456282185376474013917829429243519811721072662085485111045703987412094220689686673634241955047247609854041200778578542832459371567518406936908136456278580855326355096792872324174145562813303949605379230174018494117853603702152059335440764083293322471807283069472531202462722202917551408494598048677137074200859816690275986663030277286569976460908346358904422964424746645104732745352326121282910390649387427416055754359188091700147618060211231503082679247785691660641065431271701057523938788707846180991151470917443986898990696238399554440903455233022468088651148799684030267146193796334043119080594644322358796906759836770505103557429631622296333030266327046011619967776159634366887279937028243689380001409729105518639839675945116128815330668016315503185899714161216687671230574073946303172784011192584424549790851949628053757067125708116500923344172251805167855674009789352798000845818461242899224835938000020378170885269055841255490568216829243335871796252244109330529902983716481736108361446573154715062745211442983313584589859718458201409644684427903762533836045799364210919834689625426037370437764039595607214082990598178228046116112630636040001663147483205019386481519822689029391114522931957183171963601512521439959563534069438676951975087909832523209070515108411852576337766181331210245202556778537611245618032446627001987176726069215070633346030796232494244019728751779926096081430988292745260805874652716348627255093805602013625670873133828325514622056327230677993441485202456141624053594915112957418286324951364793572836369723116492808563095213991319047761945317187869248729375289646267504478167028273396579524813913334151803023358073522405222549035123864804815678071618740638054974112593483726390502113599929647317259818412046014321600804441793135484014715991040128640051384584336103707601446933382393773627271309500975826400733339412405476577984912684169457984989567273831263186466544309763153431065963866240968246813680236626161775578250353653632304278658916659205865168664633596162571073255555785527047441982726477428415441608391620914299858924649341080842414427042884773862327960684379853819918113906923732799168708234502574103035248876408173859907743983277977179889939690429027728899836034303103846198087243860133694609495003085594474285042927122313337572294151335513419111029590872832714904180393358701596366385951443810672106202469574018799513459696965569155880094143095244341376943866450111670328409290239406024323584249461010638411786389182375518466075581091820058065184342719352703433649383541885319070885434140096435888895915838399889468766955213317926658229843966956015883000989184322171710713223649126536034372588359814912282338149828331742475288776165758624668302616582826157942988548761128057396876656217465326482735010879330795681553493747259618459826243669763540270027708731304870445825284361682698093387761793742048304278104093500532463894820462859057282396283759525305867486353270235939534246792138612608840528996034304412039332005879449134846209923941893166636009769500421980450818388532886689781787068817196712858933448063045608771626658106014788519330242475177372495165820226543420903872341980336920464845619553623926915434440577108858461813046669675213100608647130957218743496405831782804948156306093884408227146007099300059879697593185055729716721089763708268661326778789153938771996075981554131700962184855700361219028651893129459248410229172748625837731140325878800075436691689542794858719884224083845593868131724898886440575779158384233204867975224464329634148174423778660117199058743344643347405140437467793625685821216020779247523666721758801733589747337849247346899425349147268152461678125906071471834676112405343343956698976393725993977695617708488484909616454320408236182254100663514392663988532469781250088749171558917572313626520320178676148544919877041358098554483954790172091138185361565655261012863907079644076228772780748351151926491215503647185415971443705202181767609730806089770801035429749998043792312851884644743752813258139875276310149574144396379172372433319740886535397849571861903477542572434740208689196188897381758130683224720946734486870662993972958242564498642289481257673061271646154799451748897408440149105922652489081901881190687295443602490373855311584574590569819672287646003467989460539878700753688516834744400655248098721042798094922853807034173937553014758910903166723693219094324958985538822226275412837868767849455864993908045703165812516453925106076720925664553211297349630885657515014079813436986731838509436367169544767983588348172639936282163815402727935993699213679304559824496017851460676697897561329983501996510963688138874655152475344904323788272122634729260781509246326358372566482432472194713353700628497335073777469597999790082549366484067173305172474929907836440985423540565767243778594081828708945224070163357648368651464839780435877072249325792168345131643285292301344844968174212466176541002362066701716438334393602510379752410453535501774417268612253289131889040539333102428437613225420554729020100465702534065578988787694649021448405621508669423820835999946793329162317636529741456662520053535310703552737556758998800108529809665211831386755353866127149625163666779521322727930638163656890122830323910546848030636543332249360303039404438910588249720932306541563590770596925332441479321749157111249066406550557696231957852075133719500736203578650066813155988760390174715181370216345598412623392598864950301027169922675662182959278772058241220076908068561820691331178873268044491717169569011045123586361336089584037973586874622600834671824806671811098540809367330724392994098844290463613143289532328775319183024595903171732536374124988795744073909040413308180261874890993381644921381274607102275620405042127210382719983082685633866484392100738884373676686979899044294781411673631215505276518116221540575820837344924985303468053846195655413116266031120844021436834615165161472761479297894656802478387122781254486866876028528475220274133079206008736124537893667972984881218229985926338252796260887834458813714575859009379935614974051839193281981297824005736639857016030291148184720157796439522000826862540346487723465189977369189882601926042049659661063643206563237843559200905087283130352202990209189223108945473494240717500360891066395194741480745156765009222906935515433358682588895905416741543996511360937592478388725605389719306466810380027885711190100698281872210494382939688609171235794755465526434836854853832912247923196199966028777141052554294671972317063437414723165040433612516879993128928872841172738808153392441022928739731085880277177493185489461756392591259000087065681837528998559187231981473331080573187926672726930585739939888272495695285777375302525902472988714375966921511442117458516678245895080868501740982654276036044560620520065518030631867236770513316758754103689961254256359861141701271540896101025082179652139128056988035169507273892915247469263858016614803662933936230160620854212420346408215267232249922568522099691758589620507335724997813111105030641744067465593772218513211477334999346130140206221426772875328790818589390667159108462025159490124949540066157019389321256733646476754426996654717162188226741532138935795707734537510573574153893253425413281031566662480032673914324808453322722499260898566901940251790312824537149175649667700005717
    ##  /33264402841837255560349406117879831215495039816338611012209182619472191541894259205428296072930514706148313134532448580419087078279090789069870230300818780265008134430774247569464925797913696964537456409532700489437025357773021227550021255963905299597172887614582950137545724040239246041764170911555793687677112086521835611732481117177891957235524825887374670849621010850571181204040715695709171052015096794232454864112868733701628615574721969904245609843733230781579664977309021287316159369744484331843163531748971992510242076371925431946730355919226785500693640759946794924682020358155850952618123050460526190754784693449780957488164347534999409564002074580271536847087086921145339279315352860434862497234729590853650485757056523379668241827747611156476419336350315323486974881243667917367731781048684363030264673830233062520433713740449151979443447490906138069875150399751903544550577624991850469340823946765869330376668000189495775594381782682778031285713870836709801997767637441119303671434695417613684153460870305342868472240468955500320890696390793105154293470049652304615308661936325097106048943250272356864722920331774440222138731369136540448795634537068940345750535130938347798162166175117895731089408143893464595500791049476638884311787505050714379895085363709493095166800524328381354895661597285981234101635802065644444502628624669032694493703359968894571040979464403864941299058911577015609568259581919982283009672135689645081659860658519494654028239164392931394859922056178870907135255434432869831154867097938557964192234165001977565504294742789037015037400452220446520067482124465665190845782618458856184961946589346404166132228507878943325076670404741876701455524715344277836571497693045572973375747362295671741701807931727693040653343465311124801855857254443794700369517474044267706844153944398161827202196602896389363565320448794778738094307360294100245018282541478067967049003121446997827752272130857020166454334273703688901260601073356756676910053224728662497449982731176317461481413221354237773567426238784510530856083089122577263786912007877984248779746887199496568258985031981745699075184418063407090421186497027321221634397838860454106798846779561865849835990934702798367109223472452837161048970909474492933210441446045137728124348097835645661870949154259825078332193490106906957884306275168868076077093193480076981926191392790143004882887302295103849066909668866503667925481555791382815071759138446335291510588351454746567603250701036180024307736270619726666399054055820740137214908290461246130705019921390550874356384984265520768025502519236722377296675364612175096266535210161446882313898204323805042131313890489543841109198909227369117582144432442198160140324878965724386708682285816720913485765962288839863851625971850672279417411764036414084732202481118856781737258330101182200968849260848307881877914570552473301844781294382619293360202598822198575551498215240062173118925032996319979761741830312100000147195346451370469415564050152187026595454332829011850743472599810154902228512712967921338617921281414264629584544511134406928428179792402654347282832655721235837631489717455480272168085055391950256212832656595947896552653764783508990702728431541488849965211226645225519044138614048090116493362127783469943458667907819151385091811814552197080361798277165354840326324099882143215396459357755198526608135182333850908437876040208597117786233154368061101603107598197256783296211739735558842491358443427682396127666029970557542464481674870797420720487182264967048698280464543180486039223366355861247450513367356835591209333722147683011339805720250543383372473396275839578797415552911151926799463881045084759094078004596796892072608745970157502804412417888731418195702085382719463878114493773698596581254200300387111827288513437803152354147064931784194427600379762105179046152666945649652907627804754496400395696477932219873340528413307213931247296286867072249428145798741977510787744904008248393155032324940410962721229092722379339539861719264238283712253805003748760884933288442527628486217842453934704772150794530231503283278089565505168620177892958213853026815386541404715220153652545856865986923929778749536982423525032916892842949554771645147152083669905146632991549232311925529673744618457966305211578933862381189871744709120954014942021581791625306655692824062256889600740993512524990096331708048036366571948952907509257270969423846457941898405496272090362279785959795181744588650122759945949081887838534365129271878710921318092021788460152659314462189318741633728680168208222928998218292783321173363686981529877572962248051621726093634859093941972137262493586948257012306286747967013082743329999247973893673081597262419260171281273490963890193116729138383416104944415269484841564099108038453618669065429120256092765171228082675810488264622796118853633866122991514821794184150740812246074751983200525837532858794659782784622615626836093385918544309782879099877179902121495225072612400010817450415545329420072737269835594167923371449491072932070624592681558694572707768956889327480435267432510190501177515725808362421019160229086420362092967948491793634153703214463588506996558499722779629923668094605915423195631572470764238633590255662125991835866355941842332198480913676625450188569960308451906289527117969094587824814470058885056081417133412767443339670896413969830537619538970176124887841696308216810943296383559500134949665993684928873627638699525791956398577734738994891596400994844249726102400944716525461712485203259398296485102557311636680484477552730814681845987476342273189477508739378373121352983539924761597482504364519321088456402274911461181514144830638556514696656847114340044778831826180982709021038305150445967243015955163912943126218632586487956271430395743890720548471837484731949814734485523523998727547393899605823924385089991318450121081178528243764673256161706784775854196446900973979672782753497517567985383313134414846684670387662643538721087547173295763830033198259702065595263039968305694259042822085142235103285993782978615887428173092189977846684761838363721490671386488846048408200918150803901198053890796285689694323167048240376786488600906735478814959460899161883137618579846359798418294209436649286559925662103975491713598755617015934110547768284554944478036488859390163205373042832190923808964631989146651072692491006811396402738795366557398341911218977614695670815730533569809694824196890006055878006454108489936668911082741607188988463196571428652073639554751575232389071210793434612825330805437992585615237827050636793497381238153484089205286860770633219792429961782976462193366367866791864719508480982292217534264549738584007068775735480394416835481403455817589920031201290556253536456036610688217111644491171269193561162398786454710716183190114899487341528476773882186512310827069112494481912585593360293453345205620122988419303457331674163827617236935071659762909831466360008440141555324932144952971274474537376264554687854379678628034748170796612684104505881097033772586636808929594109962393683728837371021778692307565437884189525703187497742739990243925011600363197093423965985115356578555432404021897972588598036476773451067161509135663143450811411986213361049161516465445773298837516589129787104314541601579417501236864492550766578261048370032013161070726860032209214134931342985987629142820893274771434806903214787375372778373370706103857998979941153374806575871083415439042230462963103634053847109972645460439720828415003193524703979383370133072534900668546683235995478363653653195114262237020838649504970998021249362492168196239186603983767942097894916755461694307551477154681114831402126069473779539970316039319986720036446305432725174898264760816423873714389780315904921963418760894889610952095835066891394318524364729100362458731755867661527245519850209107298781078041399724377569864732449895875542557219164511267995824339480872731173499186782391832829564918280937833935927611404299888631265559539486723814521074677744446633385106520472438884215545943530388553006662382424129871601979026884378569431849646272074539539584660768204573450044406445190866516025008258454344958749612909545168167640200038030904814229214358370820446197819040500716555513500536640814823879805431577609790132049303870745004630414173903227918192132116798703961633720220159794695895892129620885189962065533528870545023650911936062839656491987620337222408560457872872488559448946173026871601759807326578999201633410398565099094020751344023413680048350699713441437881843014697501248387719839832864530039699146049618899448561805422839678172391612177718904777699104987723632979965333342423421020715661865014763847773042161439279283022603223015527076982157542643853382180549104283340100656314099214441929166761859014799586372485120000000000

``` r
iprint(r)
```

    ## [1] "(%i2) sum(1/x^2, x, 1, 10000)"

``` r
maxima.isInstalled()
```

    ## [1] TRUE

``` r
maxima.version()
```

    ## [1] '5.44.0'

``` r
maxima.options
```

    ##  Option        Value 
    ##  -------------:-----------------------------------------------------------------
    ##  format        linear
    ##                (Printing format of returned object from maxima.get())
    ##  engine.format latex 
    ##                (Same as 'format', but for maxima code chunks in
    ##                'RMarkdown' documents.)
    ##  inline.format inline
    ##                (Same as 'engine.format', but for printing output inline
    ##                via maxima.inline(). Cannot be set to 'ascii'.)
    ##  label         TRUE  
    ##                (Sets whether a maxima reference label should be printed
    ##                when printing a maxima return object.)
    ##  engine.label  TRUE  
    ##                (Same as 'label', but for maxima code chunks.)
    ##  inline.label  FALSE 
    ##                (Same as 'label', but for inline code chunks)

``` r
maxima.options(format = "ascii")
maxima.apropos("int")
```

    ## (%o3) [adjoint, adjoint-impl, askinteger, askinteger-impl, 
    ## beta_args_sum_to_integer, cint, defint, defint-impl, disjointp, 
    ## disjointp-impl, display_format_internal, expint, expint-impl, expintegral_chi, 
    ## expintegral_chi-impl, expintegral_ci, expintegral_ci-impl, expintegral_e, 
    ## expintegral_e-impl, expintegral_e1, expintegral_e1-impl, expintegral_ei, 
    ## expintegral_ei-impl, expintegral_hyp, expintegral_li, expintegral_li-impl, 
    ## expintegral_shi, expintegral_shi-impl, expintegral_si, expintegral_si-impl, 
    ## expintegral_trig, expintexpand, expintrep, factor_max_degree_print_warning, 
    ## floatint, fpprintprec, gcprint, intanalysis, integer, integer_partitions, 
    ## integer_partitions-impl, integerp, integerp-impl, integervalued, integral, 
    ## integrate, integrate-impl, integrate_use_rootsof, integration_constant, 
    ## integration_constant_counter, interaction, interpolate, intersect, 
    ## intersect-impl, intersection, intersection-impl, intervalp, intfaclim, 
    ## intopois, intopois-impl, intosum, intosum-impl, invert_by_adjoint, 
    ## invert_by_adjoint-impl, invert_by_adjoint_size_limit, ldefint, ldefint-impl, 
    ## linespoints, lisp_print, loadprint, lognegint, mapprint, maxfpprintprec, 
    ## maxpsinegint, maxpsiposint, mdebug_print_length, ninth, nointegrate, 
    ## noninteger, nonnegintegerp, noprint, point_type, pointbound, points, poisint, 
    ## poisint-impl, print, print-impl, printf, printfile, printfile-impl, printpois, 
    ## printpois-impl, printprops, printvarlist, printvarlist-impl, ratprint, 
    ## require_integer, require_posinteger, require_selfadjoint_matrix, specint, 
    ## specint-impl, sprint, tldefint, tldefint-impl, e-integer-coeff]

``` r
maxima.get("integrate(1 / (x^4 + 1), x);")
```

    ##                                                                2 x + sqrt(2)
    ##            2                         2                    atan(-------------)
    ##       log(x  + sqrt(2) x + 1)   log(x  - sqrt(2) x + 1)           sqrt(2)
    ## (%o4) ----------------------- - ----------------------- + -------------------
    ##                 5/2                       5/2                     3/2
    ##                2                         2                       2
    ##                                                                  2 x - sqrt(2)
    ##                                                             atan(-------------)
    ##                                                                     sqrt(2)
    ##                                                           + -------------------
    ##                                                                     3/2
    ##                                                                    2

``` r
maxima.get("jacobian( [alpha / (alpha + beta), 1 / sqrt(alpha + beta)], [alpha, beta] )")
```

    ##            [      1              alpha                alpha        ]
    ##            [ ------------ - ---------------    - ---------------   ]
    ##            [ beta + alpha                 2                    2   ]
    ##            [                (beta + alpha)       (beta + alpha)    ]
    ## (%o5)      [                                                       ]
    ##            [                1                           1          ]
    ##            [     - -------------------       - ------------------- ]
    ##            [                       3/2                         3/2 ]
    ##            [       2 (beta + alpha)            2 (beta + alpha)    ]

``` r
l <- maxima.get("%;")
unclass(l)
```

    ## $wtl
    ## $wtl$linear
    ## [1] "(%o6) matrix([1/(beta+alpha)-alpha/(beta+alpha)^2,-alpha/(beta+alpha)^2],"
    ## [2] "             [-1/(2*(beta+alpha)^(3/2)),-1/(2*(beta+alpha)^(3/2))])"      
    ## 
    ## $wtl$ascii
    ## [1] "           [      1              alpha                alpha        ]"
    ## [2] "           [ ------------ - ---------------    - ---------------   ]"
    ## [3] "           [ beta + alpha                 2                    2   ]"
    ## [4] "           [                (beta + alpha)       (beta + alpha)    ]"
    ## [5] "(%o6)      [                                                       ]"
    ## [6] "           [                1                           1          ]"
    ## [7] "           [     - -------------------       - ------------------- ]"
    ## [8] "           [                       3/2                         3/2 ]"
    ## [9] "           [       2 (beta + alpha)            2 (beta + alpha)    ]"
    ## 
    ## $wtl$latex
    ## [1] "$$\\mathtt{(\\textit{\\%o}_{6})}\\quad \\begin{pmatrix}\\frac{1}{\\beta+\\alpha}-\\frac{\\alpha}{\\left(\\beta+\\alpha\\right)^2} & -\\frac{\\alpha}{\\left(\\beta+\\alpha\\right)^2} \\\\ -\\frac{1}{2\\,\\left(\\beta+\\alpha\\right)^{\\frac{3}{2}}} & -\\frac{1}{2\\,\\left(\\beta+\\alpha\\right)^{\\frac{3}{2}}} \\\\ \\end{pmatrix}$$"
    ## 
    ## $wtl$inline
    ## [1] "$\\mathtt{(\\textit{\\%o}_{6})}\\quad \\begin{pmatrix}\\frac{1}{\\beta+\\alpha}-\\frac{\\alpha}{\\left(\\beta+\\alpha\\right)^2} & -\\frac{\\alpha}{\\left(\\beta+\\alpha\\right)^2} \\\\ -\\frac{1}{2\\,\\left(\\beta+\\alpha\\right)^{\\frac{3}{2}}} & -\\frac{1}{2\\,\\left(\\beta+\\alpha\\right)^{\\frac{3}{2}}} \\\\ \\end{pmatrix}$"
    ## 
    ## $wtl$mathml
    ##  [1] " <math xmlns=\"http://www.w3.org/1998/Math/MathML\"> <mi>mlabel</mi> " 
    ##  [2] " <mfenced separators=\"\"><msub><mi>%o</mi> <mn>6</mn></msub> "        
    ##  [3] " <mo>,</mo><mfenced separators=\"\" open=\"(\" close=\")\"><mtable>"   
    ##  [4] " <mtr><mtd><mfrac><mrow><mn>1</mn> </mrow> <mrow><mi>&beta;</mi> "     
    ##  [5] " <mo>+</mo> <mi>&alpha;</mi> </mrow></mfrac> <mo>-</mo> <mfrac><mrow>" 
    ##  [6] " <mi>&alpha;</mi> </mrow> <mrow><msup><mrow><mfenced separators=\"\">" 
    ##  [7] " <mi>&beta;</mi> <mo>+</mo> <mi>&alpha;</mi> </mfenced> </mrow> "      
    ##  [8] " <mn>2</mn> </msup> </mrow></mfrac> </mtd><mtd><mo>-</mo>"             
    ##  [9] " <mfrac><mrow><mi>&alpha;</mi> </mrow> <mrow><msup><mrow>"             
    ## [10] " <mfenced separators=\"\"><mi>&beta;</mi> <mo>+</mo> <mi>&alpha;</mi> "
    ## [11] " </mfenced> </mrow> <mn>2</mn> </msup> </mrow></mfrac> </mtd></mtr> "  
    ## [12] " <mtr><mtd><mo>-</mo><mfrac><mrow><mn>1</mn> </mrow> <mrow>"           
    ## [13] " <mn>2</mn> <mspace width=\"thinmathspace\"/><msup><mrow>"             
    ## [14] " <mfenced separators=\"\"><mi>&beta;</mi> <mo>+</mo> <mi>&alpha;</mi> "
    ## [15] " </mfenced> </mrow> <mrow><mfrac><mrow><mn>3</mn> </mrow> <mrow>"      
    ## [16] " <mn>2</mn> </mrow></mfrac> </mrow></msup> </mrow></mfrac> "           
    ## [17] " </mtd><mtd><mo>-</mo><mfrac><mrow><mn>1</mn> </mrow> <mrow>"          
    ## [18] " <mn>2</mn> <mspace width=\"thinmathspace\"/><msup><mrow>"             
    ## [19] " <mfenced separators=\"\"><mi>&beta;</mi> <mo>+</mo> <mi>&alpha;</mi> "
    ## [20] " </mfenced> </mrow> <mrow><mfrac><mrow><mn>3</mn> </mrow> <mrow>"      
    ## [21] " <mn>2</mn> </mrow></mfrac> </mrow></msup> </mrow></mfrac> "           
    ## [22] " </mtd></mtr> </mtable></mfenced> </mfenced> </math>"                  
    ## 
    ## 
    ## $wol
    ## $wol$linear
    ## [1] "matrix([1/(beta+alpha)-alpha/(beta+alpha)^2,-alpha/(beta+alpha)^2],"
    ## [2] "       [-1/(2*(beta+alpha)^(3/2)),-1/(2*(beta+alpha)^(3/2))])"      
    ## 
    ## $wol$ascii
    ## [1] "[      1              alpha                alpha        ]"
    ## [2] "[ ------------ - ---------------    - ---------------   ]"
    ## [3] "[ beta + alpha                 2                    2   ]"
    ## [4] "[                (beta + alpha)       (beta + alpha)    ]"
    ## [5] "[                                                       ]"
    ## [6] "[                1                           1          ]"
    ## [7] "[     - -------------------       - ------------------- ]"
    ## [8] "[                       3/2                         3/2 ]"
    ## [9] "[       2 (beta + alpha)            2 (beta + alpha)    ]"
    ## 
    ## $wol$latex
    ## [1] "$$\\begin{pmatrix}\\frac{1}{\\beta+\\alpha}-\\frac{\\alpha}{\\left(\\beta+\\alpha\\right)^2} & -\\frac{\\alpha}{\\left(\\beta+\\alpha\\right)^2} \\\\ -\\frac{1}{2\\,\\left(\\beta+\\alpha\\right)^{\\frac{3}{2}}} & -\\frac{1}{2\\,\\left(\\beta+\\alpha\\right)^{\\frac{3}{2}}} \\\\ \\end{pmatrix}$$"
    ## 
    ## $wol$inline
    ## [1] "$\\begin{pmatrix}\\frac{1}{\\beta+\\alpha}-\\frac{\\alpha}{\\left(\\beta+\\alpha\\right)^2} & -\\frac{\\alpha}{\\left(\\beta+\\alpha\\right)^2} \\\\ -\\frac{1}{2\\,\\left(\\beta+\\alpha\\right)^{\\frac{3}{2}}} & -\\frac{1}{2\\,\\left(\\beta+\\alpha\\right)^{\\frac{3}{2}}} \\\\ \\end{pmatrix}$"
    ## 
    ## $wol$mathml
    ##  [1] " <math xmlns=\"http://www.w3.org/1998/Math/MathML\"> "                 
    ##  [2] " <mfenced separators=\"\" open=\"(\" close=\")\"><mtable><mtr><mtd>"   
    ##  [3] " <mfrac><mrow><mn>1</mn> </mrow> <mrow><mi>&beta;</mi> <mo>+</mo> "    
    ##  [4] " <mi>&alpha;</mi> </mrow></mfrac> <mo>-</mo> <mfrac><mrow>"            
    ##  [5] " <mi>&alpha;</mi> </mrow> <mrow><msup><mrow><mfenced separators=\"\">" 
    ##  [6] " <mi>&beta;</mi> <mo>+</mo> <mi>&alpha;</mi> </mfenced> </mrow> "      
    ##  [7] " <mn>2</mn> </msup> </mrow></mfrac> </mtd><mtd><mo>-</mo>"             
    ##  [8] " <mfrac><mrow><mi>&alpha;</mi> </mrow> <mrow><msup><mrow>"             
    ##  [9] " <mfenced separators=\"\"><mi>&beta;</mi> <mo>+</mo> <mi>&alpha;</mi> "
    ## [10] " </mfenced> </mrow> <mn>2</mn> </msup> </mrow></mfrac> </mtd></mtr> "  
    ## [11] " <mtr><mtd><mo>-</mo><mfrac><mrow><mn>1</mn> </mrow> <mrow>"           
    ## [12] " <mn>2</mn> <mspace width=\"thinmathspace\"/><msup><mrow>"             
    ## [13] " <mfenced separators=\"\"><mi>&beta;</mi> <mo>+</mo> <mi>&alpha;</mi> "
    ## [14] " </mfenced> </mrow> <mrow><mfrac><mrow><mn>3</mn> </mrow> <mrow>"      
    ## [15] " <mn>2</mn> </mrow></mfrac> </mrow></msup> </mrow></mfrac> "           
    ## [16] " </mtd><mtd><mo>-</mo><mfrac><mrow><mn>1</mn> </mrow> <mrow>"          
    ## [17] " <mn>2</mn> <mspace width=\"thinmathspace\"/><msup><mrow>"             
    ## [18] " <mfenced separators=\"\"><mi>&beta;</mi> <mo>+</mo> <mi>&alpha;</mi> "
    ## [19] " </mfenced> </mrow> <mrow><mfrac><mrow><mn>3</mn> </mrow> <mrow>"      
    ## [20] " <mn>2</mn> </mrow></mfrac> </mrow></msup> </mrow></mfrac> "           
    ## [21] " </mtd></mtr> </mtable></mfenced> </math>"                             
    ## 
    ## 
    ## attr(,"input.label")
    ## [1] "%i6"
    ## attr(,"output.label")
    ## [1] "%o6"
    ## attr(,"command")
    ## [1] "%;"
    ## attr(,"suppressed")
    ## [1] FALSE

``` r
maxima.load("abs_integrate")
maxima.stop()
```
