% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fx-prices.R
\name{riingo_fx_prices}
\alias{riingo_fx_prices}
\title{Forex - Prices}
\usage{
riingo_fx_prices(
  ticker,
  start_date = NULL,
  end_date = NULL,
  resample_frequency = "1day"
)
}
\arguments{
\item{ticker}{One or more fx tickers to download financial metrics for, such
as \code{"audusd"} or \code{"eurusd"}.}

\item{start_date}{The first date to download data for.
A character in the form YYYY-MM-DD, or a \code{Date} variable. The default is to
download 1 year's worth of data.}

\item{end_date}{The last date to download data for.
A character in the form YYYY-MM-DD, or a \code{Date} variable.}

\item{resample_frequency}{A single character specified at the \code{"day"},
\code{"min"} or \code{"hour"} frequencies in the form: \code{"1day"}, \code{"1min"},
\code{"5min"}, or \code{"2hour"}.}
}
\value{
A data frame containing the fx prices for the requested tickers.
}
\description{
This function collects forex prices for specified tickers. It can return
daily, hourly, and minutely data, however, the amount of returned data
becomes more limited with a finer resolution.
}
\examples{
\dontrun{
start <- Sys.Date() - 10
riingo_fx_prices(c("audusd", "eurusd"), start_date = start)
}
}
