% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rif.R
\name{get_rif_quantiles}
\alias{get_rif_quantiles}
\alias{get_rif_quantile}
\title{Estimate RIF at Quantiles}
\usage{
get_rif_quantiles(dep_var, weights, probs, ...)

get_rif_quantile(dep_var, weights, probs, ...)
}
\arguments{
\item{dep_var}{dependent variable of a distributional function. Discrete or continuous numeric vector.}

\item{weights}{numeric vector of non-negative observation weights, hence of same length as \code{dep_var}.
The default (\code{NULL)} is equivalent to \code{weights = rep(1, length(dep_var))}.}

\item{probs}{the specific quantile at which to estimate the RIF.}

\item{...}{further arguments passed on to \link[stats]{density}.}
}
\value{
A data frame with the number of columns equaling the length of vector \code{probs} and an additional column containing the weights.
        Each column contains the RIF values at the quantile's probabilities.
}
\description{
Function to estimate the recentered influence function (RIF) at one or several specified quantiles
of a weighted distribution of a dependent variable.
}
\section{Functions}{
\itemize{
\item \code{get_rif_quantile()}: Helper function to estimate the RIF values at a specific quantile.

}}
\examples{
dep_var <- c(1, 3, 9, 16, 3, 7, 4, 9)
probs <- seq(1:9) / 10
weights <- c(2, 1, 3, 4, 4, 1, 6, 3)
get_rif_quantiles(dep_var, probs, weights = weights)

}
