% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rif.R
\name{get_rif_interquantile_ratio}
\alias{get_rif_interquantile_ratio}
\title{Estimate RIF of interquantile ratio}
\usage{
get_rif_interquantile_ratio(dep_var, weights, probs, ...)
}
\arguments{
\item{dep_var}{dependent variable of a distributional function. Discrete or continuous numeric vector.}

\item{weights}{numeric vector of non-negative observation weights, hence of same length as \code{dep_var}.
The default (\code{NULL)} is equivalent to \code{weights = rep(1, length(dep_var))}.}

\item{probs}{a vector of length 2 with probabilities corresponding to the quantiles in the ratio's numerator and the denominator.
The function defines the interquantile ratio as the ratio between the quantile with the larger probability (numerator) and
the quantile with the lower probability (denominator).}

\item{...}{further arguments passed on to \link[stats]{density}.}
}
\value{
A data frame with one column containing the RIF of the interquantile ratio for each observation.
}
\description{
Compute the recentered influence function (RIF) of a weighted
interquantile ratio.
}
\examples{

set.seed(123)
dep_var <- rlnorm(100)
weights <- rep(1, 100)
get_rif_interquantile_ratio(dep_var, probs = c(0.1, 0.9), weights = weights)

}
\references{
Chung, Choe, and Philippe Van Kerm. 2018. "Foreign workers and the wage distribution: What
does the infuence function reveal?", \emph{Econometrics} 6(3), 41.
}
