% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_weights.R
\name{check_weights}
\alias{check_weights}
\title{Check weights}
\usage{
check_weights(dep_var, weights)
}
\arguments{
\item{dep_var}{dependent variable of distributional function.
Can be any discrete or continuous vector of length 1 or more.}

\item{weights}{positive numeric vector of \code{length(dep_var)}
containing the weights or \code{NULL}.}
}
\value{
positive numeric vector of \code{length(dep_var)}
        containing the checked weights. If \code{weights = NULL}, all weights are set to 1.
}
\description{
Helper function to check a weights vector. Makes sure the weights
are positive numeric values (not all zeros) and of the same length as the
dependent variable \code{dep_var}. Replaces all \code{NA}s with 0 and sets
all weights to 1 if weights is set to NULL.
}
\examples{

dep_var <- c(1, 3, 9, 16, 3, 7, 4, 9)
weights <- c(2, 1, 3, 4, 4, 1, 6, 3)
check_weights(dep_var, weights)

}
