% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/callback-itm.R
\name{add_weight}
\alias{add_weight}
\alias{calc_dur}
\title{Internal item callback utilities}
\usage{
add_weight(x, env, weight_var = "weight")

calc_dur(x, val_var, min_var, max_var, grp_var = NULL)
}
\arguments{
\item{x}{Object in loading}

\item{env}{Data source environment as available as \code{env} in callback
functions}

\item{weight_var}{String valued name of the newly added weight column}

\item{val_var}{String valued column name corresponding to the value variable}

\item{min_var, max_var}{Column names denoting start and end times}

\item{grp_var}{Optional grouping variable (for example linking infusions)}
}
\value{
An \code{id_tbl} or \code{ts_tbl} object, potentially modified by reference.
}
\description{
The utility function \code{add_weight()} is exported for convenience when adding
external datasets and integrating concepts such as vasopressor rates which
rely on patient weight. For this to function, the newly added dataset must
offer a \code{weight} concept. For performance reasons, the weight concept is
internally cached, as this might be used unchanged many times, when loading
several concepts that need to pull in patient weight data.
}
\keyword{internal}
