% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/var_select.R
\name{var_select}
\alias{var_select}
\title{Perform Variable Selection using Three Threshold-based Procedures}
\usage{
var_select(
  M.burnin,
  M.keep,
  M.thin = 1,
  status,
  y.train,
  x.train,
  trt.train,
  x.test,
  trt.test,
  cluster.id,
  verbose = FALSE,
  n_permuate,
  alpha = 0.1
)
}
\arguments{
\item{M.burnin}{A numeric value indicating the number of MCMC iterations to be treated as burn in.}

\item{M.keep}{A numeric value indicating the number of MCMC posterior draws after burn in.}

\item{M.thin}{A numeric value indicating the thinning parameter.}

\item{status}{A vector of event indicators: status = 1 indicates that the event was observed while status = 0 indicates the observation was right-censored.}

\item{y.train}{A vector of follow-up times.}

\item{x.train}{A dataframe or matrix, including all the covariates but not treatments for training data, with rows corresponding to observations and columns to variables.}

\item{trt.train}{A numeric vector representing the treatment groups for the training data.}

\item{x.test}{A dataframe or matrix, including all the covariates but not treatments for testing data, with  rows corresponding to observations and columns to variables.}

\item{trt.test}{A numeric vector representing the treatment groups for the testing data.}

\item{cluster.id}{A vector of integers representing the clustering id. The cluster id should be an integer and start from 1.}

\item{verbose}{A logical indicating whether to show the progress bar. The default is FALSE.}

\item{n_permuate}{Number of permutations of the event time together with the censoring indicator to generate the null permutation distribution.}

\item{alpha}{Cut-off level for the thresholds.}
}
\value{
A list with the following elements:
\item{var_local_selected:}{A character vector including all the variables selected using Local procedure.}
\item{var_max_selected:}{A character vector including all the variables selected using Global Max procedure.}
\item{var_global_se_selected:}{A character vector including all the variables selected using Global SE procedure.}
\item{vip_perm:}{The permutation distribution for the variable inclusion proportions generated by permuting the event time together with the censoring indicator.}
\item{vip_obs:}{The variable inclusion proportions for the actual data.}
}
\description{
Performs variable selection with ri-AFTBART using the three thresholding methods introduced in Bleich et al. (2013).
}
\examples{
\donttest{
set.seed(20181223)
n = 2
k = 50
N = n*k
cluster.id = rep(1:n, each=k)
tau.error = 0.8
b = rnorm(n, 0, tau.error)
alpha = 2
beta1 = 1
beta2 = -1
beta3 = -2
sig.error = 0.5
censoring.rate = 0.02
x1 = rnorm(N,0.5,1)
x2 = rnorm(N,1.5,0.5)
error = rnorm(N,0,sig.error)
logtime = alpha + beta1*x1 + beta2*x2 + b[cluster.id] + error
y = exp(logtime)
C = rexp(N, rate=censoring.rate)
Y = pmin(y,C)
status = as.numeric(y<=C)
trt.train = sample(c(1,2,3), N, prob = c(0.4,0.3,0.2), replace = TRUE)
trt.test = sample(c(1,2,3), N, prob = c(0.3,0.4,0.2), replace = TRUE)
res <- var_select(M.burnin = 10, M.keep = 10, M.thin = 1, status = status,
                      y.train = Y, trt.train = trt.train, trt.test = trt.test,
                      x.train = cbind(x1,x2),
                      x.test = cbind(x1,x2),
                      cluster.id = cluster.id,
                      n_permuate = 4,alpha = 0.1)
                      }
}
