% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list.R
\name{list_package_checks}
\alias{list_package_checks}
\title{List checks of a package}
\usage{
list_package_checks(package = ".", email = NULL, howmany = 20)
}
\arguments{
\item{package}{Directory of an R package, or a package tarball.}

\item{email}{Email address that was used for the check(s).
If \code{NULL}, then the maintainer address is used.}

\item{howmany}{How many checks to show. The current maximum of the API
is 20.}
}
\value{
A \link[tibble:tibble]{tibble::tibble} with columns:
\itemize{
\item package Name of the package.
\item version Package version.
\item result: More detailed result of the check. Can be \code{NULL} for errors.
This is a list column with members: \code{status}, \code{errors}, \code{warnings},
\code{notes}.
\item group: R-hub check group id.
\item id: `R-hub check id.
\item platform_name: Name of the check platform.
\item build_time: Build time, a \link{difftime} object.
\item submitted: Time of submission.
\item started: Time of the check start.
\item platform: Detailed platform data, a list column.
\item builder: Name of the builder machine.
\item status Status of the check. Possible values:
\itemize{
\item \code{created}: check job was created, but not running yet.
\item \verb{in-progress}: check job is running.
\item \code{parseerror}: internal R-hub error parsing the check results.
\item \code{preperror}: check error, before the package check has started.
\item \code{aborted}: aborted by admin or user.
\item \code{error}: failed check. (Possibly warnings and notes as well.)
\item \code{warning}: \verb{R CMD check} reported warnings. (Possibly notes as well.)
\item \code{note}: \verb{R CMD check} reported notes.
\item \code{ok}: successful check.
}
\item email: Email address of maintainer / submitter.
}
}
\description{
List checks of a package
}
\examples{
\dontrun{
ch <- list_package_checks()
ch
ch$details(1)
}
}
