% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bispectra.R
\name{bispectrum}
\alias{bispectrum}
\title{Estimate bispectrum from time series data.}
\usage{
bispectrum(
  data,
  window_function = NULL,
  mc = FALSE,
  mc_cores = getOption("mc.cores", 2L)
)
}
\arguments{
\item{data}{Given time series, as a data frame or matrix with which columns
correspond to sampled stretches.}

\item{window_function}{A window function's name for tapering. Defaults to
\code{NULL} ("no tapering").

Currently the following window functions are available: Hamming window ("hamming"),
Hann window ("hann"), and Blackman window ("blackman").}

\item{mc}{If \code{TRUE}, calculation is done in parallel computation.
Defaults to \code{FALSE}.}

\item{mc_cores}{The number of cores in use for parallel computation, passed
\code{\link[parallel:mclapply]{parallel::mcmapply}()} etc. as \code{mc.cores}.}
}
\value{
A data frame including the following columns:
\describe{
\item{f1:}{
The first elements of frequency pairs.
}
\item{f2:}{
The second elements of frequency pairs.
}
\item{value:}{
The estimated bispectrum at each frequency pair.
}
}
}
\description{
Estimate bispectrum from real- or complex-valued time series data.
}
\examples{
f <- function(x) {
    sin(2 * x) + sin(3 * x + 1) + sin(2 * x) * sin(3 * x + 1)
}
v <- sapply(seq_len(1280), f) + rnorm(1280)
m <- matrix(v, nrow = 128)
bs1 <- bispectrum(m)
bs2 <- bispectrum(m, "hamming")
bs3 <- bispectrum(m, "blackman", mc = TRUE, mc_cores = 1L)

}
\references{
Brillinger, D.R. and Irizarry, R.A.
"An investigation of the second- and higher-order spectra of music."
Signal Processing, Volume 65, Issue 2, 30 March 1998, Pages 161-179.
}
