% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sklearn-scalers.R
\name{RobustScaler}
\alias{RobustScaler}
\title{Scales features using statistics that are robust to outliers}
\description{
This scaler removes the median and scales the data according to the quantile
range (defaults to IQR: Interquartile Range). The IQR is the range between
the 1st quartile (25th quantile) and the 3rd quartile (75th quantile).

Centering and scaling happen independently on each feature by computing the
relevant statistics on the samples in the training set. Median and
interquartile range are then stored to be used on later data using the
\verb{$transform()} method.

Standardization of a dataset is a common requirement for many machine
learning estimators. Typically this is done by removing the mean and scaling
to unit variance. However, outliers can often influence the sample mean /
variance in a negative way. In such cases, the median and the interquartile
range often give better results.
}
\examples{
\dontshow{if (reticulate::py_module_available("sklearn.preprocessing")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
rs <- RobustScaler$new()
\dontshow{\}) # examplesIf}
}
\section{Super classes}{
\code{rgudhi::PythonClass} -> \code{rgudhi::SKLearnClass} -> \code{\link[rgudhi:BaseScaler]{rgudhi::BaseScaler}} -> \code{RobustScaler}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-RobustScaler-new}{\code{RobustScaler$new()}}
\item \href{#method-RobustScaler-clone}{\code{RobustScaler$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="PythonClass" data-id="get_python_class"><a href='../../rgudhi/html/PythonClass.html#method-PythonClass-get_python_class'><code>rgudhi::PythonClass$get_python_class()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="PythonClass" data-id="set_python_class"><a href='../../rgudhi/html/PythonClass.html#method-PythonClass-set_python_class'><code>rgudhi::PythonClass$set_python_class()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="SKLearnClass" data-id="apply"><a href='../../rgudhi/html/SKLearnClass.html#method-SKLearnClass-apply'><code>rgudhi::SKLearnClass$apply()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="SKLearnClass" data-id="fit"><a href='../../rgudhi/html/SKLearnClass.html#method-SKLearnClass-fit'><code>rgudhi::SKLearnClass$fit()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="SKLearnClass" data-id="fit_transform"><a href='../../rgudhi/html/SKLearnClass.html#method-SKLearnClass-fit_transform'><code>rgudhi::SKLearnClass$fit_transform()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="SKLearnClass" data-id="get_params"><a href='../../rgudhi/html/SKLearnClass.html#method-SKLearnClass-get_params'><code>rgudhi::SKLearnClass$get_params()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="SKLearnClass" data-id="set_params"><a href='../../rgudhi/html/SKLearnClass.html#method-SKLearnClass-set_params'><code>rgudhi::SKLearnClass$set_params()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="SKLearnClass" data-id="transform"><a href='../../rgudhi/html/SKLearnClass.html#method-SKLearnClass-transform'><code>rgudhi::SKLearnClass$transform()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RobustScaler-new"></a>}}
\if{latex}{\out{\hypertarget{method-RobustScaler-new}{}}}
\subsection{Method \code{new()}}{
The \link{RobustScaler} class constructor.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RobustScaler$new(
  with_centering = TRUE,
  with_scaling = TRUE,
  quantile_range = c(25, 75),
  copy = TRUE,
  unit_variance = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{with_centering}}{A boolean value specifying whether to center the
data before scaling. This will cause transform to raise an exception
when attempted on sparse matrices, because centering them entails
building a dense matrix which in common use cases is likely to be too
large to fit in memory. Defaults to \code{TRUE}.}

\item{\code{with_scaling}}{A boolean value specifying whether to scale the data
to interquartile range. Defaults to \code{TRUE}.}

\item{\code{quantile_range}}{A length-2 numeric vector specifying the quantile
range used to calculate \code{scale_}. Defaults to \code{c(25.0, 75.0)}.}

\item{\code{copy}}{A boolean value specifying whether to perform in-place
scaling and avoid a copy (if the input is already a numpy array).
Defaults to \code{TRUE}.}

\item{\code{unit_variance}}{A boolean value specifying whether to scale data so
that normally distributed features have a variance of 1. In general, if
the difference between the x-values of \eqn{q_{\max}} and
\eqn{q_{\min}} for a standard normal distribution is greater than 1,
the data set will be scaled down. If less than 1, the data set will be
scaled up. Defaults to \code{FALSE}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An object of class \link{RobustScaler}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RobustScaler-clone"></a>}}
\if{latex}{\out{\hypertarget{method-RobustScaler-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RobustScaler$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
