% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rgl.camera.R
\name{rgl.camera}
\alias{rgl.camera}
\title{Place observer}
\usage{
rgl.camera(position = NULL, direction = NULL, up = NULL, fov = 0)
}
\arguments{
\item{position}{either a 3-vector, a single number or NULL. A vector directly specifies the location of camera. A single number specifies the distances of the camera along the z-axis, relative to the center of the scene (= center of the bounding box returned by \code{\link[rgl]{par3d}}). If no positions is given, then the camera is placed automatically.}

\item{direction}{optional 3-vector specifying the direction in which the observer is looking, that is the optical axis of the virtual camera. The norm of the vector is irrelevant, but has to be non-zero. If not given, the camera is pointed at the center of the scene.}

\item{up}{optional single number or 3-vector, specifying the rotation of the camera around the optical axis (as defined with the argument direction). If a single number is provided, it is normally interpreted as the angle in degrees between the up-direction of the 2d camera image and the projected z-axis of the 3d scene. To avoid the singularity that occurs if the optical axis lies very close to the z-axis, "up" is, in this case, interpreted as the angle between the up-direction and the y-axis. If a 3-vector is provided, it is interpreted such that its projection points upwards on the projected image seen by the camera. Thus, this 3-vector must *not* be parallel to the direction.}

\item{fov}{field of view in degrees, as used in \code{\link[rgl]{view3d}}. This is roughly the field-of-view seen along the shortest axis of the window.}
}
\value{
None
}
\description{
Set the position, orientation and field-of-view of the observer
}
\examples{
# Draw knot
rgl::open3d()
a = seq(0,2*pi,len=25)
knot = rgl::cylinder3d(center=cbind(sin(a)+2*sin(2*a), 2*sin(3*a), cos(a)-2*cos(2*a)),
                       e1 = cbind(cos(a)+4*cos(2*a), 6*cos(3*a), sin(a)+4*sin(2*a)),
                       radius = 0.8, closed = TRUE)
rgl::shade3d(rgl::addNormals(rgl::subdivision3d(knot,depth=2)), col="purple")

# Place static camera
rgl.camera(c(10,0,0),fov=50)

# Animate camera
\dontrun{
  for(alpha in seq(0,2*pi,len=100)) {
    rgl.camera(10*c(cos(alpha),sin(alpha),0),fov=50)
  }
}

}
\author{
Danail Obreschkow
}
