% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weights.R
\name{spatial_lag}
\alias{spatial_lag}
\title{Spatial Lag}
\usage{
spatial_lag(gda_w, df)
}
\arguments{
\item{gda_w}{A Weight object}

\item{df}{A data frame with selected variable only. E.g. guerry["Crm_prs"]}
}
\value{
A data.frame with one column "Spatial Lag"
}
\description{
Compute the spatial lag for idx-th observation using selected variable and current weights matrix
}
\examples{
\dontrun{
library(sf)
guerry_path <- system.file("extdata", "Guerry.shp", package = "rgeoda")
guerry <- st_read(guerry_path)
queen_w <- queen_weights(guerry)
crm_lag <- spatial_lag(queen_w, guerry["Crm_prs"])
crm_lag
}
}
