% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{skater}
\alias{skater}
\title{Spatial C(K)luster Analysis by Tree Edge Removal}
\usage{
skater(
  k,
  w,
  df,
  bound_variable = data.frame(),
  min_bound = 0,
  scale_method = "standardize",
  distance_method = "euclidean",
  random_seed = 123456789,
  cpu_threads = 6,
  rdist = numeric()
)
}
\arguments{
\item{k}{The number of clusters}

\item{w}{An instance of Weight class}

\item{df}{A data frame with selected variables only.
E.g. guerry[c("Crm_prs", "Crm_prp", "Litercy")]}

\item{bound_variable}{(optional) A data frame with selected bound variable}

\item{min_bound}{(optional) A minimum bound value that applies to all
clusters}

\item{scale_method}{One of the scaling methods ('raw', 'standardize',
'demean', 'mad', 'range_standardize', 'range_adjust') to apply on input data.
Default is 'standardize' (Z-score normalization).}

\item{distance_method}{(optional) The distance method used to compute the
distance betwen observation i and j. Defaults to "euclidean". Options are
"euclidean" and "manhattan"}

\item{random_seed}{(int,optional) The seed for random number generator.
Defaults to 123456789.}

\item{cpu_threads}{(optional) The number of cpu threads used for parallel
computation}

\item{rdist}{(optional) The distance matrix (lower triangular matrix,
column wise storage)}
}
\value{
A names list with names "Clusters", "Total sum of squares",
"Within-cluster sum of squares", "Total within-cluster sum of squares",
and "The ratio of between to total sum of squares".
}
\description{
SKATER forms clusters by spatially partitioning data that has
similar values for features of interest.
}
\examples{
library(sf)
guerry_path <- system.file("extdata", "Guerry.shp", package = "rgeoda")
guerry <- st_read(guerry_path)
queen_w <- queen_weights(guerry)
data <- guerry[c('Crm_prs','Crm_prp','Litercy','Donatns','Infants','Suicids')]
guerry_clusters <- skater(4, queen_w, data)
guerry_clusters
}
