% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{gb_max_adm_lvl}
\alias{gb_max_adm_lvl}
\title{Get the highest administrative level available for a given country}
\usage{
gb_max_adm_lvl(
  country = NULL,
  release_type = c("gbOpen", "gbHumanitarian", "gbAuthoritative")
)
}
\arguments{
\item{country}{characher; a vector of country names or iso3 country codes.}

\item{release_type}{character; This is one of gbOpen, gbHumanitarian, or gbAuthoritative.
For most users, we suggest using gbOpen, as it is CC-BY 4.0 compliant, and can be used
for most purposes so long as attribution is provided. gbHumanitarian files are
mirrored from UN OCHA, but may have less open licensure. gbAuthoritative files are
mirrored from UN SALB, and cannot be used for commerical purposes,
but are verified through in-country processes. Default to gbOpen.}
}
\value{
a data.frame with the country names and corresponding highest administrative level
}
\description{
Get the highest administrative level available for a given country
}
