% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ComByName.R
\name{ComByName}
\alias{ComByName}
\title{Get City by Name}
\usage{
ComByName(nom, boost = FALSE, postal = FALSE)
}
\arguments{
\item{nom}{a character string with the name of the city, in full ASCII character.}

\item{boost}{a TRUE or FALSE. Default is FALSE. If TRUE, typographic pertinence score will be weighted by population.}

\item{postal}{wether or not to include postal codes. Default is FALSE.}
}
\value{
Returns a data.frame with name(s), INSEE code(s), postal code(s), INSEE department code(s), INSEE region code(s), population (approx), surface(s) (in hectares), lat and long (WGS-84).
}
\description{
Get informations about a French city by its name (partial matches possible). Please note that this package works only with French cities.
}
\details{
Takes a the name of a French city, returns a data.frame with the available values. Partial matches are possible. In that case, typographic pertinence scores are given, and can be weighted by population with the "boost" argument.
}
\examples{
ComByName(nom = "Brest")
ComByName(nom = "Rennes", boost = TRUE)
ComByName(nom = "Lo", postal = TRUE)
}

