/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables.impl;

import java.util.Iterator;
import org.chocosolver.memory.IEnvironment;
import org.chocosolver.memory.IStateInt;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.delta.IIntDeltaMonitor;
import org.chocosolver.solver.variables.delta.IIntervalDelta;
import org.chocosolver.solver.variables.delta.IntervalDelta;
import org.chocosolver.solver.variables.delta.NoDelta;
import org.chocosolver.solver.variables.delta.monitor.IntervalDeltaMonitor;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.solver.variables.impl.AbstractVariable;
import org.chocosolver.solver.variables.impl.scheduler.IntEvtScheduler;
import org.chocosolver.solver.variables.impl.siglit.SignedLiteral;
import org.chocosolver.util.iterators.DisposableRangeBoundIterator;
import org.chocosolver.util.iterators.DisposableRangeIterator;
import org.chocosolver.util.iterators.DisposableValueBoundIterator;
import org.chocosolver.util.iterators.DisposableValueIterator;
import org.chocosolver.util.iterators.EvtScheduler;
import org.chocosolver.util.iterators.IntVarValueIterator;
import org.chocosolver.util.objects.setDataStructures.iterable.IntIterableRangeSet;
import org.chocosolver.util.objects.setDataStructures.iterable.IntIterableSet;

public final class IntervalIntVarImpl
extends AbstractVariable
implements IntVar {
    private boolean reactOnRemoval = false;
    private final IStateInt LB;
    private final IStateInt UB;
    private final IStateInt SIZE;
    private IIntervalDelta delta = NoDelta.singleton;
    private DisposableValueIterator _viterator;
    private DisposableRangeIterator _riterator;
    private IntVarValueIterator _javaIterator;
    protected SignedLiteral.Set literal;

    public IntervalIntVarImpl(String name, int min, int max, Model model) {
        super(name, model);
        IEnvironment env = model.getEnvironment();
        this.LB = env.makeInt(min);
        this.UB = env.makeInt(max);
        this.SIZE = env.makeInt(max - min + 1);
    }

    @Override
    public boolean removeValue(int value, ICause cause) throws ContradictionException {
        assert (cause != null);
        if (value == this.getLB()) {
            return this.updateLowerBound(value + 1, cause);
        }
        if (value == this.getUB()) {
            return this.updateUpperBound(value - 1, cause);
        }
        return false;
    }

    @Override
    public boolean removeValues(IntIterableSet values, ICause cause) throws ContradictionException {
        int olb = this.getLB();
        int oub = this.getUB();
        int nlb = values.nextValue(olb - 1);
        int nub = values.previousValue(oub + 1);
        if (nlb > oub || nub < olb) {
            return false;
        }
        if (nlb == olb) {
            do {
                olb = this.nextValue(olb);
                nlb = values.nextValue(olb - 1);
            } while (olb < Integer.MAX_VALUE && oub < Integer.MAX_VALUE && nlb == olb);
        }
        if (nub == oub) {
            do {
                oub = this.previousValue(oub);
                nub = values.previousValue(oub + 1);
            } while (olb > Integer.MIN_VALUE && oub > Integer.MIN_VALUE && nub == oub);
        }
        return this.updateBounds(olb, oub, cause);
    }

    @Override
    public boolean removeAllValuesBut(IntIterableSet values, ICause cause) throws ContradictionException {
        int olb = this.getLB();
        int oub = this.getUB();
        int nlb = values.nextValue(olb - 1);
        int nub = values.previousValue(oub + 1);
        return this.updateBounds(nlb, nub, cause);
    }

    @Override
    public boolean removeInterval(int from, int to, ICause cause) throws ContradictionException {
        assert (cause != null);
        if (from <= this.getLB()) {
            return this.updateLowerBound(to + 1, cause);
        }
        if (this.getUB() <= to) {
            return this.updateUpperBound(from - 1, cause);
        }
        return false;
    }

    @Override
    public boolean instantiateTo(int value, ICause cause) throws ContradictionException {
        assert (cause != null);
        if (!this.contains(value)) {
            this.model.getSolver().getEventObserver().instantiateTo(this, value, cause, this.getLB(), this.getUB());
            this.contradiction(cause, "the variable is already instantiated to another value");
        } else if (!this.isInstantiated()) {
            int lb = this.getLB();
            int ub = this.getUB();
            this.model.getSolver().getEventObserver().instantiateTo(this, value, cause, lb, ub);
            IntEventType e = IntEventType.INSTANTIATE;
            if (this.reactOnRemoval) {
                if (lb <= value - 1) {
                    this.delta.add(lb, value - 1, cause);
                }
                if (value + 1 <= ub) {
                    this.delta.add(value + 1, ub, cause);
                }
            }
            this.LB.set(value);
            this.UB.set(value);
            this.SIZE.set(1);
            this.notifyPropagators(e, cause);
            return true;
        }
        return false;
    }

    @Override
    public boolean updateLowerBound(int value, ICause cause) throws ContradictionException {
        assert (cause != null);
        int old = this.getLB();
        if (old < value) {
            this.model.getSolver().getEventObserver().updateLowerBound(this, value, old, cause);
            int oub = this.getUB();
            if (oub < value) {
                this.contradiction(cause, "the new lower bound is greater than the current upper bound");
            } else {
                IntEventType e = IntEventType.INCLOW;
                if (this.reactOnRemoval) {
                    this.delta.add(old, value - 1, cause);
                }
                this.SIZE.add(old - value);
                this.LB.set(value);
                if (this.isInstantiated()) {
                    e = IntEventType.INSTANTIATE;
                }
                this.notifyPropagators(e, cause);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean updateUpperBound(int value, ICause cause) throws ContradictionException {
        assert (cause != null);
        int old = this.getUB();
        if (old > value) {
            this.model.getSolver().getEventObserver().updateUpperBound(this, value, old, cause);
            int olb = this.getLB();
            if (olb > value) {
                this.contradiction(cause, "the new upper bound is lesser than the current lower bound");
            } else {
                IntEventType e = IntEventType.DECUPP;
                if (this.reactOnRemoval) {
                    this.delta.add(value + 1, old, cause);
                }
                this.SIZE.add(value - old);
                this.UB.set(value);
                if (this.isInstantiated()) {
                    e = IntEventType.INSTANTIATE;
                }
                this.notifyPropagators(e, cause);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean updateBounds(int lb, int ub, ICause cause) throws ContradictionException {
        assert (cause != null);
        int olb = this.getLB();
        int oub = this.getUB();
        boolean update = false;
        if (olb < lb || ub < oub) {
            IntEventType e = null;
            int d = 0;
            if (oub < lb) {
                this.model.getSolver().getEventObserver().updateLowerBound(this, lb, olb, cause);
                this.contradiction(cause, "the new lower bound is greater than the current upper bound");
            } else if (olb < lb) {
                this.model.getSolver().getEventObserver().updateLowerBound(this, lb, olb, cause);
                e = IntEventType.INCLOW;
                if (this.reactOnRemoval) {
                    this.delta.add(olb, lb - 1, cause);
                }
                d += olb - lb;
                this.LB.set(lb);
                olb = lb;
            }
            if (olb > ub) {
                this.model.getSolver().getEventObserver().updateUpperBound(this, ub, oub, cause);
                this.contradiction(cause, "the new upper bound is lesser than the current lower bound");
            } else if (oub > ub) {
                this.model.getSolver().getEventObserver().updateUpperBound(this, ub, oub, cause);
                IntEventType intEventType = e = e == null ? IntEventType.DECUPP : IntEventType.BOUND;
                if (this.reactOnRemoval) {
                    this.delta.add(ub + 1, oub, cause);
                }
                d += ub - oub;
                this.UB.set(ub);
            }
            this.SIZE.add(d);
            if (this.isInstantiated()) {
                e = IntEventType.INSTANTIATE;
            }
            this.notifyPropagators(e, cause);
            update = true;
        }
        return update;
    }

    @Override
    public boolean isInstantiated() {
        return this.SIZE.get() == 1;
    }

    @Override
    public boolean isInstantiatedTo(int value) {
        return this.isInstantiated() && this.getLB() == value;
    }

    @Override
    public boolean contains(int aValue) {
        return aValue >= this.LB.get() && aValue <= this.UB.get();
    }

    @Override
    public int getValue() {
        assert (this.isInstantiated()) : this.name + " not instantiated";
        return this.getLB();
    }

    @Override
    public int getLB() {
        return this.LB.get();
    }

    @Override
    public int getUB() {
        return this.UB.get();
    }

    @Override
    public int getDomainSize() {
        return this.SIZE.get();
    }

    @Override
    public int getRange() {
        return this.getDomainSize();
    }

    @Override
    public int nextValue(int aValue) {
        int lb = this.LB.get();
        if (aValue < lb) {
            return lb;
        }
        if (aValue < this.UB.get()) {
            return aValue + 1;
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public int nextValueOut(int v) {
        int ub = this.UB.get();
        if (this.LB.get() - 1 <= v && v <= ub) {
            return ub + 1;
        }
        return v + 1;
    }

    @Override
    public int previousValue(int aValue) {
        int ub = this.UB.get();
        if (aValue > ub) {
            return ub;
        }
        if (aValue > this.LB.get()) {
            return aValue - 1;
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public int previousValueOut(int v) {
        int lb = this.LB.get();
        if (lb <= v && v <= this.UB.get() + 1) {
            return lb - 1;
        }
        return v - 1;
    }

    @Override
    public boolean hasEnumeratedDomain() {
        return false;
    }

    @Override
    public IIntervalDelta getDelta() {
        return this.delta;
    }

    @Override
    public String toString() {
        if (this.SIZE.get() == 1) {
            return String.format("%s = %d", this.name, this.getLB());
        }
        return String.format("%s = [%d,%d]", this.name, this.getLB(), this.getUB());
    }

    @Override
    public void createDelta() {
        if (!this.reactOnRemoval) {
            this.delta = new IntervalDelta(this.model.getEnvironment());
            this.reactOnRemoval = true;
        }
    }

    @Override
    public IIntDeltaMonitor monitorDelta(ICause propagator) {
        this.createDelta();
        return new IntervalDeltaMonitor(this.delta, propagator);
    }

    @Override
    public int getTypeAndKind() {
        return 9;
    }

    protected EvtScheduler createScheduler() {
        return new IntEvtScheduler();
    }

    @Override
    public DisposableValueIterator getValueIterator(boolean bottomUp) {
        if (this._viterator == null || this._viterator.isNotReusable()) {
            this._viterator = new DisposableValueBoundIterator(this);
        }
        if (bottomUp) {
            this._viterator.bottomUpInit();
        } else {
            this._viterator.topDownInit();
        }
        return this._viterator;
    }

    @Override
    public DisposableRangeIterator getRangeIterator(boolean bottomUp) {
        if (this._riterator == null || this._riterator.isNotReusable()) {
            this._riterator = new DisposableRangeBoundIterator(this);
        }
        if (bottomUp) {
            this._riterator.bottomUpInit();
        } else {
            this._riterator.topDownInit();
        }
        return this._riterator;
    }

    @Override
    public Iterator<Integer> iterator() {
        if (this._javaIterator == null) {
            this._javaIterator = new IntVarValueIterator(this);
        }
        this._javaIterator.reset();
        return this._javaIterator;
    }

    @Override
    public void createLit(IntIterableRangeSet rootDomain) {
        if (this.literal != null) {
            throw new IllegalStateException("createLit(Implications) called twice");
        }
        this.literal = new SignedLiteral.Set(rootDomain);
    }

    @Override
    public SignedLiteral getLit() {
        if (this.literal == null) {
            throw new NullPointerException("getLit() called on null, a call to createLit(Implications) is required");
        }
        return this.literal;
    }
}

